/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throttler {
    private double desiredRatePerSec;
    private long checkIntervalMs;
    private boolean throttleDown;
    private final Object lock = new Object();
    private final Object waitGuard = new Object();
    private long periodStartNs;
    private double observedSoFar;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Time time;
    private boolean enabled;

    public Throttler(double desiredRatePerSec, long checkIntervalMs, boolean throttleDown, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.checkIntervalMs = checkIntervalMs;
        this.throttleDown = throttleDown;
        this.time = time;
        this.observedSoFar = 0.0;
        this.periodStartNs = time.nanoseconds();
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeThrottle(double observed) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.observedSoFar += observed;
            long now = this.time.nanoseconds();
            long elapsedNs = now - this.periodStartNs;
            if ((this.checkIntervalMs < 0L || elapsedNs > this.checkIntervalMs * 1000000L) && this.observedSoFar > 0.0) {
                double elapsedMs;
                double desiredRateMs;
                long sleepTime;
                double rateInSecs = elapsedNs > 0L ? this.observedSoFar * 1.0E9 / (double)elapsedNs : Double.MAX_VALUE;
                if (this.throttleDown == rateInSecs > this.desiredRatePerSec && (sleepTime = Math.round(this.observedSoFar / (desiredRateMs = this.desiredRatePerSec / 1000.0) - (elapsedMs = (double)(elapsedNs / 1000000L)))) > 0L) {
                    this.logger.trace("Natural rate is {} per second but desired rate is {}, sleeping for {} ms to compensate.", new Object[]{rateInSecs, this.desiredRatePerSec, sleepTime});
                    Object object2 = this.waitGuard;
                    synchronized (object2) {
                        if (this.enabled) {
                            this.time.wait(this.waitGuard, sleepTime);
                        }
                    }
                }
                this.periodStartNs = now;
                this.observedSoFar = 0.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this.waitGuard;
        synchronized (object) {
            this.enabled = false;
            this.waitGuard.notify();
        }
    }
}

