/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.Crc32;
import java.io.IOException;
import java.io.OutputStream;

public class CrcOutputStream
extends OutputStream {
    private Crc32 crc;
    private OutputStream stream;

    public CrcOutputStream(OutputStream out) {
        this(new Crc32(), out);
    }

    public CrcOutputStream(Crc32 crc, OutputStream out) {
        this.crc = crc;
        this.stream = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
        this.crc.update((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
        this.crc.update(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.crc.update(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public long getValue() {
        return this.crc.getValue();
    }
}

