/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ChannelWriter {
    private final WritableByteChannel channel;
    private static final int size = 1024;
    private final ByteBuffer buffer = ByteBuffer.allocate(1024);

    public ChannelWriter(WritableByteChannel channel) {
        this.channel = channel;
    }

    public void writeInt(int value) throws IOException {
        this.buffer.clear();
        this.buffer.putInt(value);
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    public void writeLong(long value) throws IOException {
        this.buffer.clear();
        this.buffer.putLong(value);
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    public void writeShort(short value) throws IOException {
        this.buffer.clear();
        this.buffer.putShort(value);
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    public void writeString(String s) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes("UTF-8"));
        this.writeStream(stream, s.length());
    }

    public void writeStream(InputStream stream, long streamSize) throws IOException {
        this.buffer.clear();
        this.writeLong(streamSize);
        this.buffer.clear();
        int i = 0;
        while ((long)i < streamSize) {
            this.buffer.put((byte)stream.read());
            if (i % 1024 == 0) {
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.clear();
            }
            ++i;
        }
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    public void writeBuffer(ByteBuffer buffer) throws IOException {
        this.writeLong(buffer.limit());
        this.channel.write(buffer);
    }
}

