/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;
    private int mark;
    private int readLimit;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.mark = -1;
        this.readLimit = -1;
    }

    public ByteBufferInputStream(InputStream stream, int size) throws IOException {
        this.byteBuffer = Utils.getByteBufferFromInputStream(stream, size);
        this.mark = -1;
        this.readLimit = -1;
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int count = Math.min(this.byteBuffer.remaining(), length);
        if (count == 0) {
            return -1;
        }
        this.byteBuffer.get(bytes, offset, count);
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.byteBuffer.remaining();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.readLimit == -1 || this.mark == -1) {
            throw new IOException("Mark not set before reset invoked.");
        }
        if (this.byteBuffer.position() - this.mark > this.readLimit) {
            throw new IOException("Read limit exceeded before reset invoked.");
        }
        this.byteBuffer.reset();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.mark = this.byteBuffer.position();
        this.readLimit = readLimit;
        this.byteBuffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public ByteBufferInputStream duplicate() {
        return new ByteBufferInputStream(this.byteBuffer.duplicate());
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer.asReadOnlyBuffer();
    }
}

