/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.IBitSet;
import com.github.ambry.utils.IFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class BloomFilter
implements IFilter {
    public final IBitSet bitset;
    public final int hashCount;

    BloomFilter(int hashes, IBitSet bitset) {
        this.hashCount = hashes;
        this.bitset = bitset;
    }

    private long[] getHashBuckets(ByteBuffer key) {
        return this.getHashBuckets(key, this.hashCount, this.bitset.capacity());
    }

    protected abstract long[] hash(ByteBuffer var1, int var2, int var3, long var4);

    long[] getHashBuckets(ByteBuffer b, int hashCount, long max) {
        long[] result = new long[hashCount];
        long[] hash = this.hash(b, b.position(), b.remaining(), 0L);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash[0] + (long)i * hash[1]) % max);
        }
        return result;
    }

    @Override
    public void add(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            this.bitset.set(bucketIndex);
        }
    }

    @Override
    public boolean isPresent(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            if (this.bitset.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.bitset.clear();
    }

    @Override
    public void close() throws IOException {
        this.bitset.close();
    }
}

