/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobData;
import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.messageformat.MessageFormatErrorCodes;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.messageformat.PutMessageFormatInputStream;
import com.github.ambry.store.Message;
import com.github.ambry.store.MessageInfo;
import com.github.ambry.store.StoreKey;
import com.github.ambry.store.StoreKeyConverter;
import com.github.ambry.store.StoreKeyFactory;
import com.github.ambry.store.TransformationOutput;
import com.github.ambry.store.Transformer;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class ValidatingTransformer
implements Transformer {
    private final StoreKeyFactory storeKeyFactory;

    public ValidatingTransformer(StoreKeyFactory storeKeyFactory, StoreKeyConverter storeKeyConverter) {
        this.storeKeyFactory = storeKeyFactory;
    }

    public TransformationOutput transform(Message message) {
        MessageInfo msgInfo = message.getMessageInfo();
        InputStream msgStream = message.getStream();
        TransformationOutput transformationOutput = null;
        try {
            ByteBuffer headerVersion = ByteBuffer.allocate(2);
            msgStream.read(headerVersion.array());
            short version = headerVersion.getShort();
            if (!MessageFormatRecord.isValidHeaderVersion(version)) {
                throw new MessageFormatException("Header version not supported " + version, MessageFormatErrorCodes.Data_Corrupt);
            }
            int headerSize = MessageFormatRecord.getHeaderSizeForVersion(version);
            ByteBuffer headerBuffer = ByteBuffer.allocate(headerSize);
            headerBuffer.put(headerVersion.array());
            msgStream.read(headerBuffer.array(), 2, headerSize - 2);
            headerBuffer.rewind();
            MessageFormatRecord.MessageHeader_Format header = MessageFormatRecord.getMessageHeader(version, headerBuffer);
            StoreKey keyInStream = this.storeKeyFactory.getStoreKey(new DataInputStream(msgStream));
            if (!header.isPutRecord()) {
                throw new IllegalStateException("Message cannot be a deleted record ");
            }
            ByteBuffer encryptionKey = header.hasEncryptionKeyRecord() ? MessageFormatRecord.deserializeBlobEncryptionKey(msgStream) : null;
            BlobProperties props = MessageFormatRecord.deserializeBlobProperties(msgStream);
            ByteBuffer metadata = MessageFormatRecord.deserializeUserMetadata(msgStream);
            BlobData blobData = MessageFormatRecord.deserializeBlob(msgStream);
            if (!msgInfo.getStoreKey().equals(keyInStream)) {
                throw new IllegalStateException("StoreKey in stream: " + keyInStream + " failed to match store key from Index: " + msgInfo.getStoreKey());
            }
            PutMessageFormatInputStream transformedStream = new PutMessageFormatInputStream(keyInStream, encryptionKey, props, metadata, (InputStream)new ByteBufInputStream(blobData.content(), true), blobData.getSize(), blobData.getBlobType());
            MessageInfo transformedMsgInfo = new MessageInfo(keyInStream, transformedStream.getSize(), msgInfo.isDeleted(), msgInfo.isTtlUpdated(), msgInfo.getExpirationTimeInMs(), msgInfo.getCrc(), msgInfo.getAccountId(), msgInfo.getContainerId(), msgInfo.getOperationTimeMs());
            transformationOutput = new TransformationOutput(new Message(transformedMsgInfo, (InputStream)transformedStream));
        }
        catch (Exception e) {
            transformationOutput = new TransformationOutput(e);
        }
        return transformationOutput;
    }

    public void warmup(List<MessageInfo> messageInfos) throws Exception {
    }
}

