/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.messageformat.BlobType;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatInputStream;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.store.StoreKey;
import com.github.ambry.utils.Crc32;
import com.github.ambry.utils.CrcInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PutMessageFormatInputStream
extends MessageFormatInputStream {
    public PutMessageFormatInputStream(StoreKey key, ByteBuffer blobEncryptionKey, BlobProperties blobProperties, ByteBuffer userMetadata, InputStream blobStream, long streamSize, BlobType blobType) throws MessageFormatException {
        this(key, blobEncryptionKey, blobProperties, userMetadata, blobStream, streamSize, blobType, 0);
    }

    public PutMessageFormatInputStream(StoreKey key, ByteBuffer blobEncryptionKey, BlobProperties blobProperties, ByteBuffer userMetadata, InputStream blobStream, long streamSize) throws MessageFormatException {
        this(key, blobEncryptionKey, blobProperties, userMetadata, blobStream, streamSize, BlobType.DataBlob, 0);
    }

    public PutMessageFormatInputStream(StoreKey key, ByteBuffer blobEncryptionKey, BlobProperties blobProperties, ByteBuffer userMetadata, InputStream blobStream, long streamSize, BlobType blobType, short lifeVersion) throws MessageFormatException {
        if (MessageFormatRecord.headerVersionToUse == 1) {
            this.createStreamWithMessageHeaderV1(key, blobProperties, userMetadata, blobStream, streamSize, blobType);
        } else {
            this.createStreamWithMessageHeader(key, blobEncryptionKey, blobProperties, userMetadata, blobStream, streamSize, blobType, lifeVersion);
        }
    }

    private void createStreamWithMessageHeader(StoreKey key, ByteBuffer blobEncryptionKey, BlobProperties blobProperties, ByteBuffer userMetadata, InputStream blobStream, long streamSize, BlobType blobType, short lifeVersion) throws MessageFormatException {
        int headerSize = MessageFormatRecord.getHeaderSizeForVersion(MessageFormatRecord.headerVersionToUse);
        int blobEncryptionKeySize = blobEncryptionKey == null ? 0 : MessageFormatRecord.BlobEncryptionKey_Format_V1.getBlobEncryptionKeyRecordSize(blobEncryptionKey);
        int blobPropertiesRecordSize = MessageFormatRecord.BlobProperties_Format_V1.getBlobPropertiesRecordSize(blobProperties);
        int userMetadataSize = MessageFormatRecord.UserMetadata_Format_V1.getUserMetadataSize(userMetadata);
        long blobSize = MessageFormatRecord.Blob_Format_V2.getBlobRecordSize(streamSize);
        this.buffer = ByteBuffer.allocate(headerSize + key.sizeInBytes() + blobEncryptionKeySize + blobPropertiesRecordSize + userMetadataSize + (int)(blobSize - streamSize - 8L));
        long totalSize = (long)(blobEncryptionKeySize + blobPropertiesRecordSize + userMetadataSize) + blobSize;
        int blobEncryptionKeyRecordRelativeOffset = blobEncryptionKey == null ? -1 : headerSize + key.sizeInBytes();
        int blobPropertiesRecordRelativeOffset = blobEncryptionKey == null ? headerSize + key.sizeInBytes() : blobEncryptionKeyRecordRelativeOffset + blobEncryptionKeySize;
        int updateRecordRelativeOffset = -1;
        int userMetadataRecordRelativeOffset = blobPropertiesRecordRelativeOffset + blobPropertiesRecordSize;
        int blobRecordRelativeOffset = userMetadataRecordRelativeOffset + userMetadataSize;
        if (MessageFormatRecord.headerVersionToUse == 2) {
            MessageFormatRecord.MessageHeader_Format_V2.serializeHeader(this.buffer, totalSize, blobEncryptionKeyRecordRelativeOffset, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobRecordRelativeOffset);
        } else {
            MessageFormatRecord.MessageHeader_Format_V3.serializeHeader(this.buffer, lifeVersion, totalSize, blobEncryptionKeyRecordRelativeOffset, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobRecordRelativeOffset);
        }
        this.buffer.put(key.toBytes());
        if (blobEncryptionKey != null) {
            MessageFormatRecord.BlobEncryptionKey_Format_V1.serializeBlobEncryptionKeyRecord(this.buffer, blobEncryptionKey);
        }
        MessageFormatRecord.BlobProperties_Format_V1.serializeBlobPropertiesRecord(this.buffer, blobProperties);
        MessageFormatRecord.UserMetadata_Format_V1.serializeUserMetadataRecord(this.buffer, userMetadata);
        int bufferBlobStart = this.buffer.position();
        MessageFormatRecord.Blob_Format_V2.serializePartialBlobRecord(this.buffer, streamSize, blobType);
        Crc32 crc = new Crc32();
        crc.update(this.buffer.array(), bufferBlobStart, this.buffer.position() - bufferBlobStart);
        this.stream = new CrcInputStream(crc, blobStream);
        this.streamLength = streamSize;
        this.messageLength = (long)this.buffer.capacity() + this.streamLength + 8L;
        this.buffer.flip();
    }

    private void createStreamWithMessageHeaderV1(StoreKey key, BlobProperties blobProperties, ByteBuffer userMetadata, InputStream blobStream, long streamSize, BlobType blobType) throws MessageFormatException {
        int headerSize = MessageFormatRecord.MessageHeader_Format_V1.getHeaderSize();
        int blobPropertiesRecordSize = MessageFormatRecord.BlobProperties_Format_V1.getBlobPropertiesRecordSize(blobProperties);
        int userMetadataSize = MessageFormatRecord.UserMetadata_Format_V1.getUserMetadataSize(userMetadata);
        long blobSize = MessageFormatRecord.Blob_Format_V2.getBlobRecordSize(streamSize);
        this.buffer = ByteBuffer.allocate(headerSize + key.sizeInBytes() + blobPropertiesRecordSize + userMetadataSize + (int)(blobSize - streamSize - 8L));
        MessageFormatRecord.MessageHeader_Format_V1.serializeHeader(this.buffer, (long)(blobPropertiesRecordSize + userMetadataSize) + blobSize, headerSize + key.sizeInBytes(), -1, headerSize + key.sizeInBytes() + blobPropertiesRecordSize, headerSize + key.sizeInBytes() + blobPropertiesRecordSize + userMetadataSize);
        this.buffer.put(key.toBytes());
        MessageFormatRecord.BlobProperties_Format_V1.serializeBlobPropertiesRecord(this.buffer, blobProperties);
        MessageFormatRecord.UserMetadata_Format_V1.serializeUserMetadataRecord(this.buffer, userMetadata);
        int bufferBlobStart = this.buffer.position();
        MessageFormatRecord.Blob_Format_V2.serializePartialBlobRecord(this.buffer, streamSize, blobType);
        Crc32 crc = new Crc32();
        crc.update(this.buffer.array(), bufferBlobStart, this.buffer.position() - bufferBlobStart);
        this.stream = new CrcInputStream(crc, blobStream);
        this.streamLength = streamSize;
        this.messageLength = (long)this.buffer.capacity() + this.streamLength + 8L;
        this.buffer.flip();
    }
}

