/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.store.MessageReadSet;
import com.github.ambry.utils.ByteBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;

class MessageReadSetIndexInputStream
extends InputStream {
    private final MessageReadSet messageReadSet;
    private final int indexToRead;
    private int currentOffset;

    public MessageReadSetIndexInputStream(MessageReadSet messageReadSet, int indexToRead, int startingOffset) {
        this.messageReadSet = messageReadSet;
        if (indexToRead >= messageReadSet.count()) {
            throw new IllegalArgumentException("The index provided " + indexToRead + " is outside the bounds of the number of messages in the read set " + messageReadSet.count());
        }
        this.indexToRead = indexToRead;
        this.currentOffset = startingOffset;
    }

    @Override
    public int read() throws IOException {
        if ((long)this.currentOffset >= this.messageReadSet.sizeInBytes(this.indexToRead)) {
            return -1;
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(buf);
        long bytesRead = this.messageReadSet.writeTo(this.indexToRead, Channels.newChannel((OutputStream)bufferStream), (long)this.currentOffset, 1L);
        if (bytesRead != 1L) {
            throw new IllegalStateException("Number of bytes read for read from messageReadSet should be 1");
        }
        ++this.currentOffset;
        buf.flip();
        return buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if ((long)this.currentOffset >= this.messageReadSet.sizeInBytes(this.indexToRead)) {
            return -1;
        }
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.position(off);
        ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(buf);
        long sizeToRead = Math.min((long)len, this.messageReadSet.sizeInBytes(this.indexToRead) - (long)this.currentOffset);
        long bytesWritten = this.messageReadSet.writeTo(this.indexToRead, Channels.newChannel((OutputStream)bufferStream), (long)this.currentOffset, sizeToRead);
        this.currentOffset = (int)((long)this.currentOffset + bytesWritten);
        return (int)bytesWritten;
    }
}

