/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.utils.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MessageMetadata {
    private static final short MESSAGE_METADATA_VERSION_V1 = 1;
    private final ByteBuffer encryptionKey;
    private final short version;

    MessageMetadata(short version, ByteBuffer encryptionKey) {
        this.version = version;
        this.encryptionKey = encryptionKey;
    }

    public MessageMetadata(ByteBuffer encryptionKey) {
        this(1, encryptionKey);
    }

    public ByteBuffer getEncryptionKey() {
        return this.encryptionKey;
    }

    public short getVersion() {
        return this.version;
    }

    public int sizeInBytes() {
        return 6 + (this.encryptionKey == null ? 0 : this.encryptionKey.remaining());
    }

    public void serializeMessageMetadata(ByteBuffer outputBuffer) {
        switch (this.version) {
            case 1: {
                outputBuffer.putShort(this.version);
                if (this.encryptionKey != null) {
                    outputBuffer.putInt(this.encryptionKey.remaining()).put(this.encryptionKey);
                    break;
                }
                outputBuffer.putInt(0);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown MessageMetadata version");
            }
        }
    }

    public static MessageMetadata deserializeMessageMetadata(DataInputStream stream) throws IOException {
        MessageMetadata messageMetadata;
        short version = stream.readShort();
        switch (version) {
            case 1: {
                ByteBuffer encryptionKey = Utils.readIntBuffer((DataInputStream)stream);
                messageMetadata = new MessageMetadata(version, encryptionKey);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown MessageMetadata version");
            }
        }
        return messageMetadata;
    }
}

