/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobAll;
import com.github.ambry.messageformat.BlobData;
import com.github.ambry.messageformat.BlobInfo;
import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.messageformat.BlobPropertiesSerDe;
import com.github.ambry.messageformat.BlobType;
import com.github.ambry.messageformat.CompositeBlobInfo;
import com.github.ambry.messageformat.DeleteSubRecord;
import com.github.ambry.messageformat.DeserializedBlob;
import com.github.ambry.messageformat.DeserializedBlobEncryptionKey;
import com.github.ambry.messageformat.DeserializedBlobProperties;
import com.github.ambry.messageformat.DeserializedUserMetadata;
import com.github.ambry.messageformat.MessageFormatErrorCodes;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.SubRecord;
import com.github.ambry.messageformat.TtlUpdateSubRecord;
import com.github.ambry.messageformat.UndeleteSubRecord;
import com.github.ambry.messageformat.UpdateRecord;
import com.github.ambry.store.StoreKey;
import com.github.ambry.store.StoreKeyFactory;
import com.github.ambry.utils.Crc32;
import com.github.ambry.utils.CrcInputStream;
import com.github.ambry.utils.Pair;
import com.github.ambry.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatRecord {
    public static final int Version_Field_Size_In_Bytes = 2;
    public static final int Crc_Size = 8;
    public static final short Message_Header_Version_V1 = 1;
    public static final short Message_Header_Version_V2 = 2;
    public static final short Message_Header_Version_V3 = 3;
    public static final short BlobProperties_Version_V1 = 1;
    public static final short Update_Version_V1 = 1;
    public static final short Update_Version_V2 = 2;
    public static final short Update_Version_V3 = 3;
    public static final short Blob_Encryption_Key_V1 = 1;
    public static final short UserMetadata_Version_V1 = 1;
    public static final short Blob_Version_V1 = 1;
    public static final short Blob_Version_V2 = 2;
    public static final short Metadata_Content_Version_V2 = 2;
    public static final short Metadata_Content_Version_V3 = 3;
    public static final int Message_Header_Invalid_Relative_Offset = -1;
    static short headerVersionToUse = (short)3;
    private static final short Delete_Subrecord_Version_V1 = 1;
    private static final short Undelete_Subrecord_Version_V1 = 1;
    private static final short Ttl_Update_Subrecord_Version_V1 = 1;

    public static boolean isValidHeaderVersion(short headerVersion) {
        switch (headerVersion) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static short getCurrentMessageHeaderVersion() {
        return headerVersionToUse;
    }

    public static int getHeaderSizeForVersion(short headerVersion) throws MessageFormatException {
        switch (headerVersion) {
            case 1: {
                return MessageHeader_Format_V1.getHeaderSize();
            }
            case 2: {
                return MessageHeader_Format_V2.getHeaderSize();
            }
            case 3: {
                return MessageHeader_Format_V3.getHeaderSize();
            }
        }
        throw new MessageFormatException("Unknown header version: " + headerVersion, MessageFormatErrorCodes.Unknown_Format_Version);
    }

    public static MessageHeader_Format getMessageHeader(short headerVersion, ByteBuffer input) throws MessageFormatException {
        switch (headerVersion) {
            case 1: {
                return new MessageHeader_Format_V1(input);
            }
            case 2: {
                return new MessageHeader_Format_V2(input);
            }
            case 3: {
                return new MessageHeader_Format_V3(input);
            }
        }
        throw new MessageFormatException("Unknown header version: " + headerVersion, MessageFormatErrorCodes.Unknown_Format_Version);
    }

    public static BlobProperties deserializeBlobProperties(InputStream stream) throws IOException, MessageFormatException {
        return MessageFormatRecord.deserializeAndGetBlobPropertiesWithVersion(stream).getBlobProperties();
    }

    static DeserializedBlobProperties deserializeAndGetBlobPropertiesWithVersion(InputStream stream) throws IOException, MessageFormatException {
        CrcInputStream crcStream = new CrcInputStream(stream);
        DataInputStream inputStream = new DataInputStream((InputStream)crcStream);
        short version = inputStream.readShort();
        switch (version) {
            case 1: {
                return new DeserializedBlobProperties(1, BlobProperties_Format_V1.deserializeBlobPropertiesRecord(crcStream));
            }
        }
        throw new MessageFormatException("blob property version not supported", MessageFormatErrorCodes.Unknown_Format_Version);
    }

    public static UpdateRecord deserializeUpdateRecord(InputStream stream) throws IOException, MessageFormatException {
        CrcInputStream crcStream = new CrcInputStream(stream);
        DataInputStream inputStream = new DataInputStream((InputStream)crcStream);
        short version = inputStream.readShort();
        switch (version) {
            case 1: {
                return Update_Format_V1.deserialize(crcStream);
            }
            case 2: {
                return Update_Format_V2.deserialize(crcStream);
            }
            case 3: {
                return Update_Format_V3.deserialize(crcStream);
            }
        }
        throw new MessageFormatException("update record version not supported: " + version, MessageFormatErrorCodes.Unknown_Format_Version);
    }

    public static ByteBuffer deserializeBlobEncryptionKey(InputStream stream) throws IOException, MessageFormatException {
        return MessageFormatRecord.deserializeAndGetBlobEncryptionKeyWithVersion(stream).getEncryptionKey();
    }

    private static DeserializedBlobEncryptionKey deserializeAndGetBlobEncryptionKeyWithVersion(InputStream stream) throws IOException, MessageFormatException {
        CrcInputStream crcStream = new CrcInputStream(stream);
        DataInputStream inputStream = new DataInputStream((InputStream)crcStream);
        short version = inputStream.readShort();
        switch (version) {
            case 1: {
                return new DeserializedBlobEncryptionKey(1, BlobEncryptionKey_Format_V1.deserializeBlobEncryptionKeyRecord(crcStream));
            }
        }
        throw new MessageFormatException("blob encryption key record version not supported", MessageFormatErrorCodes.Unknown_Format_Version);
    }

    public static ByteBuffer deserializeUserMetadata(InputStream stream) throws IOException, MessageFormatException {
        return MessageFormatRecord.deserializeAndGetUserMetadataWithVersion(stream).getUserMetadata();
    }

    static DeserializedUserMetadata deserializeAndGetUserMetadataWithVersion(InputStream stream) throws IOException, MessageFormatException {
        CrcInputStream crcStream = new CrcInputStream(stream);
        DataInputStream inputStream = new DataInputStream((InputStream)crcStream);
        short version = inputStream.readShort();
        switch (version) {
            case 1: {
                return new DeserializedUserMetadata(1, UserMetadata_Format_V1.deserializeUserMetadataRecord(crcStream));
            }
        }
        throw new MessageFormatException("metadata version not supported", MessageFormatErrorCodes.Unknown_Format_Version);
    }

    static boolean isValidUserMetadataVersion(short userMetadataVersion) {
        switch (userMetadataVersion) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static BlobData deserializeBlob(InputStream stream) throws IOException, MessageFormatException {
        return MessageFormatRecord.deserializeAndGetBlobWithVersion(stream).getBlobData();
    }

    static DeserializedBlob deserializeAndGetBlobWithVersion(InputStream stream) throws IOException, MessageFormatException {
        CrcInputStream crcStream = new CrcInputStream(stream);
        DataInputStream inputStream = new DataInputStream((InputStream)crcStream);
        short version = inputStream.readShort();
        switch (version) {
            case 1: {
                return new DeserializedBlob(1, Blob_Format_V1.deserializeBlobRecord(crcStream));
            }
            case 2: {
                return new DeserializedBlob(2, Blob_Format_V2.deserializeBlobRecord(crcStream));
            }
        }
        throw new MessageFormatException("data version not supported", MessageFormatErrorCodes.Unknown_Format_Version);
    }

    static boolean isValidBlobRecordVersion(short blobRecordVersion) {
        switch (blobRecordVersion) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static BlobAll deserializeBlobAll(InputStream stream, StoreKeyFactory storeKeyFactory) throws IOException, MessageFormatException {
        MessageHeader_Format header;
        DataInputStream inputStream = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
        short headerVersion = inputStream.readShort();
        switch (headerVersion) {
            case 1: {
                ByteBuffer headerBuf = ByteBuffer.allocate(MessageHeader_Format_V1.getHeaderSize());
                headerBuf.putShort(headerVersion);
                inputStream.read(headerBuf.array(), 2, MessageHeader_Format_V1.getHeaderSize() - 2);
                headerBuf.rewind();
                header = new MessageHeader_Format_V1(headerBuf);
                break;
            }
            case 2: {
                ByteBuffer headerBuf = ByteBuffer.allocate(MessageHeader_Format_V2.getHeaderSize());
                headerBuf.putShort(headerVersion);
                inputStream.read(headerBuf.array(), 2, MessageHeader_Format_V2.getHeaderSize() - 2);
                headerBuf.rewind();
                header = new MessageHeader_Format_V2(headerBuf);
                break;
            }
            case 3: {
                ByteBuffer headerBuf = ByteBuffer.allocate(MessageHeader_Format_V3.getHeaderSize());
                headerBuf.putShort(headerVersion);
                inputStream.read(headerBuf.array(), 2, MessageHeader_Format_V3.getHeaderSize() - 2);
                headerBuf.rewind();
                header = new MessageHeader_Format_V3(headerBuf);
                break;
            }
            default: {
                throw new MessageFormatException("Message header version not supported", MessageFormatErrorCodes.Unknown_Format_Version);
            }
        }
        header.verifyHeader();
        StoreKey storeKey = storeKeyFactory.getStoreKey(inputStream);
        ByteBuffer blobEncryptionKey = null;
        if (header.hasEncryptionKeyRecord()) {
            blobEncryptionKey = MessageFormatRecord.deserializeBlobEncryptionKey(stream);
        }
        BlobProperties blobProperties = MessageFormatRecord.deserializeBlobProperties(stream);
        byte[] userMetadata = MessageFormatRecord.deserializeUserMetadata(stream).array();
        BlobData blobData = MessageFormatRecord.deserializeBlob(stream);
        return new BlobAll(storeKey, blobEncryptionKey, new BlobInfo(blobProperties, userMetadata), blobData);
    }

    public static class Metadata_Content_Format_V3 {
        private static final int NUM_OF_KEYS_FIELD_SIZE_IN_BYTES = 4;
        private static final int SIZE_OF_BLOB_FIELD_SIZE_IN_BYTES = 8;
        private static final int TOTAL_SIZE_FIELD_SIZE_IN_BYTES = 8;

        public static int getMetadataContentSize(int keySize, int numberOfKeys) {
            return 14 + numberOfKeys * (keySize + 8);
        }

        public static void serializeMetadataContentRecord(ByteBuffer outputBuffer, long totalSize, List<Pair<StoreKey, Long>> keysAndContentSizes) {
            short keySize = ((StoreKey)keysAndContentSizes.get(0).getFirst()).sizeInBytes();
            outputBuffer.putShort((short)3);
            outputBuffer.putLong(totalSize);
            outputBuffer.putInt(keysAndContentSizes.size());
            long sum = 0L;
            for (Pair<StoreKey, Long> keyAndContentSize : keysAndContentSizes) {
                if (((StoreKey)keyAndContentSize.getFirst()).sizeInBytes() != keySize) {
                    throw new IllegalArgumentException("Keys are not of same size");
                }
                outputBuffer.putLong((Long)keyAndContentSize.getSecond());
                outputBuffer.put(((StoreKey)keyAndContentSize.getFirst()).toBytes());
                sum += ((Long)keyAndContentSize.getSecond()).longValue();
            }
            if (sum != totalSize) {
                throw new IllegalArgumentException("Key content sizes do not equal total size");
            }
        }

        public static CompositeBlobInfo deserializeMetadataContentRecord(DataInputStream stream, StoreKeyFactory storeKeyFactory) throws IOException {
            ArrayList<Pair<StoreKey, Long>> keysAndContentSizes = new ArrayList<Pair<StoreKey, Long>>();
            long totalSize = stream.readLong();
            long sum = 0L;
            int numberOfKeys = stream.readInt();
            for (int i = 0; i < numberOfKeys; ++i) {
                long contentSize = stream.readLong();
                StoreKey storeKey = storeKeyFactory.getStoreKey(stream);
                keysAndContentSizes.add((Pair<StoreKey, Long>)new Pair((Object)storeKey, (Object)contentSize));
                sum += contentSize;
            }
            if (sum != totalSize) {
                throw new IllegalArgumentException("Key content sizes do not equal total size");
            }
            return new CompositeBlobInfo(keysAndContentSizes);
        }
    }

    public static class Metadata_Content_Format_V2 {
        private static final int Chunk_Size_Field_Size_In_Bytes = 4;
        private static final int Total_Size_Field_Size_In_Bytes = 8;

        public static int getMetadataContentSize(int keySize, int numberOfKeys) {
            return 14 + numberOfKeys * keySize;
        }

        public static void serializeMetadataContentRecord(ByteBuffer outputBuffer, int chunkSize, long totalSize, List<StoreKey> keys) {
            if (chunkSize <= 0 || (totalSize + (long)chunkSize - 1L) / (long)chunkSize != (long)keys.size()) {
                throw new IllegalArgumentException("Invalid totalSize or chunkSize");
            }
            short keySize = keys.get(0).sizeInBytes();
            outputBuffer.putShort((short)2);
            outputBuffer.putInt(chunkSize);
            outputBuffer.putLong(totalSize);
            for (StoreKey storeKey : keys) {
                if (storeKey.sizeInBytes() != keySize) {
                    throw new IllegalArgumentException("Keys are not of same size");
                }
                outputBuffer.put(storeKey.toBytes());
            }
        }

        public static CompositeBlobInfo deserializeMetadataContentRecord(DataInputStream stream, StoreKeyFactory storeKeyFactory) throws IOException {
            ArrayList<StoreKey> keys = new ArrayList<StoreKey>();
            int chunkSize = stream.readInt();
            long totalSize = stream.readLong();
            long numberOfKeys = (totalSize + (long)chunkSize - 1L) / (long)chunkSize;
            int i = 0;
            while ((long)i < numberOfKeys) {
                StoreKey storeKey = storeKeyFactory.getStoreKey(stream);
                keys.add(storeKey);
                ++i;
            }
            return new CompositeBlobInfo(chunkSize, totalSize, keys);
        }
    }

    public static class Blob_Format_V2 {
        public static final int Blob_Size_Field_In_Bytes = 8;
        public static final int Blob_Type_Field_In_Bytes = 2;
        private static Logger logger = LoggerFactory.getLogger(Blob_Format_V2.class);

        public static long getBlobRecordSize(long blobSize) {
            return 12L + blobSize + 8L;
        }

        public static void serializePartialBlobRecord(ByteBuffer outputBuffer, long blobContentSize, BlobType blobType) {
            outputBuffer.putShort((short)2);
            outputBuffer.putShort((short)blobType.ordinal());
            outputBuffer.putLong(blobContentSize);
        }

        public static BlobData deserializeBlobRecord(CrcInputStream crcStream) throws IOException, MessageFormatException {
            long streamCrc;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            short blobTypeOrdinal = dataStream.readShort();
            if (blobTypeOrdinal > BlobType.values().length) {
                logger.error("corrupt data while parsing blob content BlobContentType {}", (Object)blobTypeOrdinal);
                throw new MessageFormatException("corrupt data while parsing blob content", MessageFormatErrorCodes.Data_Corrupt);
            }
            BlobType blobContentType = BlobType.values()[blobTypeOrdinal];
            long dataSize = dataStream.readLong();
            if (dataSize > Integer.MAX_VALUE) {
                throw new IOException("We only support data of max size == MAX_INT. Error while reading blob from store");
            }
            ByteBuf byteBuf = Utils.readNettyByteBufFromCrcInputStream((CrcInputStream)crcStream, (int)((int)dataSize));
            long crc = crcStream.getValue();
            if (crc != (streamCrc = dataStream.readLong())) {
                logger.error("corrupt data while parsing blob content expectedcrc {} actualcrc {}", (Object)crc, (Object)streamCrc);
                throw new MessageFormatException("corrupt data while parsing blob content", MessageFormatErrorCodes.Data_Corrupt);
            }
            return new BlobData(blobContentType, dataSize, byteBuf);
        }
    }

    public static class Blob_Format_V1 {
        public static final int Blob_Size_Field_In_Bytes = 8;
        private static Logger logger = LoggerFactory.getLogger(Blob_Format_V1.class);

        public static long getBlobRecordSize(long blobSize) {
            return 10L + blobSize + 8L;
        }

        public static void serializePartialBlobRecord(ByteBuffer outputBuffer, long blobSize) {
            outputBuffer.putShort((short)1);
            outputBuffer.putLong(blobSize);
        }

        public static BlobData deserializeBlobRecord(CrcInputStream crcStream) throws IOException, MessageFormatException {
            long streamCrc;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            long dataSize = dataStream.readLong();
            if (dataSize > Integer.MAX_VALUE) {
                throw new IOException("We only support data of max size == MAX_INT. Error while reading blob from store");
            }
            ByteBuf byteBuf = Utils.readNettyByteBufFromCrcInputStream((CrcInputStream)crcStream, (int)((int)dataSize));
            long crc = crcStream.getValue();
            if (crc != (streamCrc = dataStream.readLong())) {
                logger.error("corrupt data while parsing blob content expectedcrc {} actualcrc {}", (Object)crc, (Object)streamCrc);
                throw new MessageFormatException("corrupt data while parsing blob content", MessageFormatErrorCodes.Data_Corrupt);
            }
            return new BlobData(BlobType.DataBlob, dataSize, byteBuf);
        }
    }

    public static class UserMetadata_Format_V1 {
        public static final int UserMetadata_Size_Field_In_Bytes = 4;
        private static Logger logger = LoggerFactory.getLogger(UserMetadata_Format_V1.class);

        public static int getUserMetadataSize(ByteBuffer userMetadata) {
            return 6 + userMetadata.limit() + 8;
        }

        public static void serializeUserMetadataRecord(ByteBuffer outputBuffer, ByteBuffer userMetadata) {
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)1);
            outputBuffer.putInt(userMetadata.limit());
            outputBuffer.put(userMetadata);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, UserMetadata_Format_V1.getUserMetadataSize(userMetadata) - 8);
            outputBuffer.putLong(crc.getValue());
        }

        public static ByteBuffer deserializeUserMetadataRecord(CrcInputStream crcStream) throws IOException, MessageFormatException {
            long expectedCRC;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            int usermetadataSize = dataStream.readInt();
            byte[] userMetadaBuffer = Utils.readBytesFromStream((InputStream)dataStream, (int)usermetadataSize);
            long actualCRC = crcStream.getValue();
            if (actualCRC != (expectedCRC = dataStream.readLong())) {
                logger.error("corrupt data while parsing user metadata Expected CRC " + expectedCRC + " Actual CRC " + actualCRC);
                throw new MessageFormatException("User metadata is corrupt", MessageFormatErrorCodes.Data_Corrupt);
            }
            return ByteBuffer.wrap(userMetadaBuffer);
        }
    }

    public static class BlobEncryptionKey_Format_V1 {
        public static final int Blob_Encryption_Key_Size_Field_In_Bytes = 4;
        private static Logger logger = LoggerFactory.getLogger(BlobEncryptionKey_Format_V1.class);

        public static int getBlobEncryptionKeyRecordSize(ByteBuffer blobEncryptionKey) {
            return 6 + blobEncryptionKey.remaining() + 8;
        }

        public static void serializeBlobEncryptionKeyRecord(ByteBuffer outputBuffer, ByteBuffer blobEncryptionKey) {
            int startOffset = outputBuffer.position();
            int blobEncryptionKeyRecordSize = BlobEncryptionKey_Format_V1.getBlobEncryptionKeyRecordSize(blobEncryptionKey);
            outputBuffer.putShort((short)1);
            outputBuffer.putInt(blobEncryptionKey.remaining());
            outputBuffer.put(blobEncryptionKey);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, blobEncryptionKeyRecordSize - 8);
            outputBuffer.putLong(crc.getValue());
        }

        static ByteBuffer deserializeBlobEncryptionKeyRecord(CrcInputStream crcStream) throws IOException, MessageFormatException {
            long expectedCRC;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            ByteBuffer blobEncryptionKey = Utils.readIntBuffer((DataInputStream)dataStream);
            long actualCRC = crcStream.getValue();
            if (actualCRC != (expectedCRC = dataStream.readLong())) {
                logger.error("corrupt data while parsing blob key record, expected CRC " + expectedCRC + " Actual CRC " + actualCRC);
                throw new MessageFormatException("Blob Key is corrupt", MessageFormatErrorCodes.Data_Corrupt);
            }
            return blobEncryptionKey;
        }
    }

    private static class Ttl_Update_Sub_Format_V1 {
        private static final int EXPIRE_TIME_FIELD_SIZE_IN_BYTES = 8;

        private Ttl_Update_Sub_Format_V1() {
        }

        static int getRecordSize() {
            return 10;
        }

        static void serialize(ByteBuffer outputBuffer, TtlUpdateSubRecord ttlUpdateSubRecord) {
            outputBuffer.putShort((short)1);
            outputBuffer.putLong(ttlUpdateSubRecord.getUpdatedExpiryTimeMs());
        }

        static TtlUpdateSubRecord deserialize(DataInputStream stream) throws IOException {
            long updatedExpiryTimeMs = stream.readLong();
            return new TtlUpdateSubRecord(updatedExpiryTimeMs);
        }
    }

    private static class Undelete_Sub_Format_V1 {
        private Undelete_Sub_Format_V1() {
        }

        static int getRecordSize() {
            return 2;
        }

        static void serialize(ByteBuffer outputBuffer, UndeleteSubRecord undeleteSubRecord) {
            outputBuffer.putShort((short)1);
        }

        static UndeleteSubRecord deserialize(DataInputStream stream) {
            return new UndeleteSubRecord();
        }
    }

    private static class Delete_Sub_Format_V1 {
        private Delete_Sub_Format_V1() {
        }

        static int getRecordSize() {
            return 2;
        }

        static void serialize(ByteBuffer outputBuffer, DeleteSubRecord deleteSubRecord) {
            outputBuffer.putShort((short)1);
        }

        static DeleteSubRecord deserialize(DataInputStream stream) {
            return new DeleteSubRecord();
        }
    }

    public static class Update_Format_V3 {
        private static final int RECORD_TYPE_FIELD_SIZE_IN_BYTES = 2;
        private static final int ACCOUNT_ID_FIELD_SIZE_IN_BYTES = 2;
        private static final int CONTAINER_ID_FIELD_SIZE_IN_BYTES = 2;
        private static final int UPDATE_TIME_FIELD_SIZE_IN_BYTES = 8;

        public static int getRecordSize(SubRecord.Type type) {
            int subRecordSize;
            switch (type) {
                case DELETE: {
                    subRecordSize = Delete_Sub_Format_V1.getRecordSize();
                    break;
                }
                case TTL_UPDATE: {
                    subRecordSize = Ttl_Update_Sub_Format_V1.getRecordSize();
                    break;
                }
                case UNDELETE: {
                    subRecordSize = Undelete_Sub_Format_V1.getRecordSize();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown update record type: " + (Object)((Object)type));
                }
            }
            return 16 + subRecordSize + 8;
        }

        public static void serialize(ByteBuffer outputBuffer, UpdateRecord updateRecord) {
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)3);
            outputBuffer.putShort(updateRecord.getAccountId());
            outputBuffer.putShort(updateRecord.getContainerId());
            outputBuffer.putLong(updateRecord.getUpdateTimeInMs());
            outputBuffer.putShort((short)updateRecord.getType().ordinal());
            switch (updateRecord.getType()) {
                case DELETE: {
                    Delete_Sub_Format_V1.serialize(outputBuffer, updateRecord.getDeleteSubRecord());
                    break;
                }
                case TTL_UPDATE: {
                    Ttl_Update_Sub_Format_V1.serialize(outputBuffer, updateRecord.getTtlUpdateSubRecord());
                    break;
                }
                case UNDELETE: {
                    Undelete_Sub_Format_V1.serialize(outputBuffer, updateRecord.getUndeleteSubRecord());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown update record type: " + (Object)((Object)updateRecord.getType()));
                }
            }
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, Update_Format_V3.getRecordSize(updateRecord.getType()) - 8);
            outputBuffer.putLong(crc.getValue());
        }

        static UpdateRecord deserialize(CrcInputStream crcStream) throws IOException, MessageFormatException {
            UpdateRecord updateRecord;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            short accountId = dataStream.readShort();
            short containerId = dataStream.readShort();
            long updateTimeInMs = dataStream.readLong();
            SubRecord.Type type = SubRecord.Type.values()[dataStream.readShort()];
            switch (type) {
                case DELETE: {
                    updateRecord = new UpdateRecord(accountId, containerId, updateTimeInMs, Update_Format_V3.getDeleteSubRecord(dataStream));
                    break;
                }
                case TTL_UPDATE: {
                    updateRecord = new UpdateRecord(accountId, containerId, updateTimeInMs, Update_Format_V3.getTtlUpdateSubRecord(dataStream));
                    break;
                }
                case UNDELETE: {
                    updateRecord = new UpdateRecord(accountId, containerId, updateTimeInMs, Update_Format_V3.getUndeleteSubRecord(dataStream));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown update record type: " + (Object)((Object)type));
                }
            }
            long actualCRC = crcStream.getValue();
            long expectedCRC = dataStream.readLong();
            if (actualCRC != expectedCRC) {
                throw new MessageFormatException("update record data is corrupt. Expected CRC: " + expectedCRC + ", Actual CRC: " + actualCRC, MessageFormatErrorCodes.Data_Corrupt);
            }
            return updateRecord;
        }

        private static DeleteSubRecord getDeleteSubRecord(DataInputStream inputStream) throws IOException, MessageFormatException {
            short version = inputStream.readShort();
            switch (version) {
                case 1: {
                    return Delete_Sub_Format_V1.deserialize(inputStream);
                }
            }
            throw new MessageFormatException("delete record version not supported: " + version, MessageFormatErrorCodes.Unknown_Format_Version);
        }

        private static UndeleteSubRecord getUndeleteSubRecord(DataInputStream inputStream) throws IOException, MessageFormatException {
            short version = inputStream.readShort();
            switch (version) {
                case 1: {
                    return Undelete_Sub_Format_V1.deserialize(inputStream);
                }
            }
            throw new MessageFormatException("undelete record version not supported: " + version, MessageFormatErrorCodes.Unknown_Format_Version);
        }

        private static TtlUpdateSubRecord getTtlUpdateSubRecord(DataInputStream inputStream) throws IOException, MessageFormatException {
            short version = inputStream.readShort();
            switch (version) {
                case 1: {
                    return Ttl_Update_Sub_Format_V1.deserialize(inputStream);
                }
            }
            throw new MessageFormatException("ttl update record version not supported: " + version, MessageFormatErrorCodes.Unknown_Format_Version);
        }
    }

    public static class Update_Format_V2 {
        private static final int ACCOUNT_ID_FIELD_SIZE_IN_BYTES = 2;
        private static final int CONTAINER_ID_FIELD_SIZE_IN_BYTES = 2;
        private static final int UPDATE_TIME_FIELD_SIZE_IN_BYTES = 8;

        public static int getRecordSize() {
            return 22;
        }

        public static void serialize(ByteBuffer outputBuffer, UpdateRecord updateRecord) {
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)2);
            outputBuffer.putShort(updateRecord.getAccountId());
            outputBuffer.putShort(updateRecord.getContainerId());
            outputBuffer.putLong(updateRecord.getUpdateTimeInMs());
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, Update_Format_V2.getRecordSize() - 8);
            outputBuffer.putLong(crc.getValue());
        }

        static UpdateRecord deserialize(CrcInputStream crcStream) throws IOException, MessageFormatException {
            long expectedCRC;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            short accountId = dataStream.readShort();
            short containerId = dataStream.readShort();
            long updateTimeInMs = dataStream.readLong();
            long actualCRC = crcStream.getValue();
            if (actualCRC != (expectedCRC = dataStream.readLong())) {
                throw new MessageFormatException("update record data is corrupt. Expected CRC: " + expectedCRC + ", Actual CRC: " + actualCRC, MessageFormatErrorCodes.Data_Corrupt);
            }
            return new UpdateRecord(accountId, containerId, updateTimeInMs, new DeleteSubRecord());
        }
    }

    public static class Update_Format_V1 {
        private static final int Delete_Field_Size_In_Bytes = 1;

        public static int getRecordSize() {
            return 11;
        }

        public static void serialize(ByteBuffer outputBuffer, UpdateRecord updateRecord) {
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)1);
            outputBuffer.put((byte)1);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, Update_Format_V1.getRecordSize() - 8);
            outputBuffer.putLong(crc.getValue());
        }

        static UpdateRecord deserialize(CrcInputStream crcStream) throws IOException, MessageFormatException {
            long expectedCRC;
            DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
            boolean isDeleted = dataStream.readByte() == 1;
            long actualCRC = crcStream.getValue();
            if (actualCRC != (expectedCRC = dataStream.readLong())) {
                throw new MessageFormatException("update record data is corrupt. Expected CRC: " + expectedCRC + ", Actual CRC: " + actualCRC, MessageFormatErrorCodes.Data_Corrupt);
            }
            return new UpdateRecord(-1, -1, -1L, new DeleteSubRecord());
        }
    }

    public static class BlobProperties_Format_V1 {
        private static Logger logger = LoggerFactory.getLogger(BlobProperties_Format_V1.class);

        public static int getBlobPropertiesRecordSize(BlobProperties properties) {
            return 2 + BlobPropertiesSerDe.getBlobPropertiesSerDeSize(properties) + 8;
        }

        public static void serializeBlobPropertiesRecord(ByteBuffer outputBuffer, BlobProperties properties) {
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)1);
            BlobPropertiesSerDe.serializeBlobProperties(outputBuffer, properties);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, BlobProperties_Format_V1.getBlobPropertiesRecordSize(properties) - 8);
            outputBuffer.putLong(crc.getValue());
        }

        public static BlobProperties deserializeBlobPropertiesRecord(CrcInputStream crcStream) throws IOException, MessageFormatException {
            try {
                DataInputStream dataStream = new DataInputStream((InputStream)crcStream);
                BlobProperties properties = BlobPropertiesSerDe.getBlobPropertiesFromStream(dataStream);
                long actualCRC = crcStream.getValue();
                long expectedCRC = dataStream.readLong();
                if (actualCRC != expectedCRC) {
                    logger.error("corrupt data while parsing blob properties Expected CRC " + expectedCRC + " Actual CRC " + actualCRC);
                    throw new MessageFormatException("Blob property data is corrupt", MessageFormatErrorCodes.Data_Corrupt);
                }
                return properties;
            }
            catch (Exception e) {
                logger.error("Blob property failed to be parsed. Data may be corrupt with exception {}", (Throwable)e);
                throw new MessageFormatException("Blob property failed to be parsed. Data may be corrupt", MessageFormatErrorCodes.Data_Corrupt);
            }
        }
    }

    public static class MessageHeader_Format_V3
    implements MessageHeader_Format {
        private ByteBuffer buffer;
        private static final Logger logger = LoggerFactory.getLogger(MessageHeader_Format_V3.class);
        public static final int Life_Version_Field_Offset_In_Bytes = 2;
        public static final int Life_Version_Field_Size_In_Bytes = 2;
        public static final int Total_Size_Field_Offset_In_Bytes = 4;
        public static final int Total_Size_Field_Size_In_Bytes = 8;
        private static final int Number_Of_Relative_Offset_Fields = 5;
        public static final int Relative_Offset_Field_Sizes_In_Bytes = 4;
        public static final int Blob_Encryption_Key_Relative_Offset_Field_Offset_In_Bytes = 12;
        public static final int BlobProperties_Relative_Offset_Field_Offset_In_Bytes = 16;
        public static final int Update_Relative_Offset_Field_Offset_In_Bytes = 20;
        public static final int UserMetadata_Relative_Offset_Field_Offset_In_Bytes = 24;
        public static final int Blob_Relative_Offset_Field_Offset_In_Bytes = 28;
        public static final int Crc_Field_Offset_In_Bytes = 32;

        public static int getHeaderSize() {
            return 40;
        }

        public static void serializeHeader(ByteBuffer outputBuffer, short lifeVersion, long totalSize, int blobEncryptionKeyRecordRelativeOffset, int blobPropertiesRecordRelativeOffset, int updateRecordRelativeOffset, int userMetadataRecordRelativeOffset, int blobRecordRelativeOffset) throws MessageFormatException {
            MessageHeader_Format_V3.checkHeaderConstraints(totalSize, lifeVersion, blobEncryptionKeyRecordRelativeOffset, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobRecordRelativeOffset);
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)3);
            outputBuffer.putShort(lifeVersion);
            outputBuffer.putLong(totalSize);
            outputBuffer.putInt(blobEncryptionKeyRecordRelativeOffset);
            outputBuffer.putInt(blobPropertiesRecordRelativeOffset);
            outputBuffer.putInt(updateRecordRelativeOffset);
            outputBuffer.putInt(userMetadataRecordRelativeOffset);
            outputBuffer.putInt(blobRecordRelativeOffset);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, MessageHeader_Format_V3.getHeaderSize() - 8);
            outputBuffer.putLong(crc.getValue());
            logger.trace("serializing header : version {} lifeVersion {} size {} blobEncryptionKeyRecordRelativeOffset {} blobPropertiesRecordRelativeOffset {} updateRecordRelativeOffset {} userMetadataRecordRelativeOffset {} blobRecordRelativeOffset {} crc {}", new Object[]{(short)3, lifeVersion, totalSize, blobEncryptionKeyRecordRelativeOffset, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobPropertiesRecordRelativeOffset, crc.getValue()});
        }

        private static void checkHeaderConstraints(long totalSize, short lifeVersion, int blobEncryptionKeyRecordRelativeOffset, int blobPropertiesRecordRelativeOffset, int updateRecordRelativeOffset, int userMetadataRecordRelativeOffset, int blobRecordRelativeOffset) throws MessageFormatException {
            if (totalSize <= 0L) {
                throw new MessageFormatException("checkHeaderConstraints - totalSize " + totalSize + " needs to be greater than 0", MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (lifeVersion < 0) {
                throw new MessageFormatException("checkHeaderConstraints - lifeVersion " + lifeVersion + " needs to be greater than or equal to 0", MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (blobPropertiesRecordRelativeOffset > 0 && (updateRecordRelativeOffset != -1 || userMetadataRecordRelativeOffset <= 0 || blobRecordRelativeOffset <= 0)) {
                throw new MessageFormatException("checkHeaderConstraints - blobPropertiesRecordRelativeOffset is greater than 0  but other properties do not satisfy constraints blobPropertiesRecordRelativeOffset " + blobPropertiesRecordRelativeOffset + " updateRecordRelativeOffset " + updateRecordRelativeOffset + " userMetadataRecordRelativeOffset " + userMetadataRecordRelativeOffset + " blobRecordRelativeOffset " + blobRecordRelativeOffset, MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (updateRecordRelativeOffset > 0 && (blobEncryptionKeyRecordRelativeOffset != -1 || blobPropertiesRecordRelativeOffset != -1 || userMetadataRecordRelativeOffset != -1 || blobRecordRelativeOffset != -1)) {
                throw new MessageFormatException("checkHeaderConstraints - updateRecordRelativeOffset is greater than 0  but other properties do not satisfy constraints blobEncryptionKeyRelativeOffset " + blobEncryptionKeyRecordRelativeOffset + " blobPropertiesRecordRelativeOffset " + blobPropertiesRecordRelativeOffset + " updateRecordRelativeOffset " + updateRecordRelativeOffset + " userMetadataRecordRelativeOffset " + userMetadataRecordRelativeOffset + " blobRecordRelativeOffset " + blobRecordRelativeOffset, MessageFormatErrorCodes.Header_Constraint_Error);
            }
        }

        public MessageHeader_Format_V3(ByteBuffer input) {
            this.buffer = input;
        }

        @Override
        public short getVersion() {
            return this.buffer.getShort(0);
        }

        @Override
        public short getLifeVersion() {
            return this.buffer.getShort(2);
        }

        @Override
        public boolean hasLifeVersion() {
            return true;
        }

        @Override
        public long getMessageSize() {
            return this.buffer.getLong(4);
        }

        @Override
        public int getBlobPropertiesRecordRelativeOffset() {
            return this.buffer.getInt(16);
        }

        @Override
        public int getBlobPropertiesRecordSize() {
            return this.getUserMetadataRecordRelativeOffset() - this.getBlobPropertiesRecordRelativeOffset();
        }

        @Override
        public boolean isPutRecord() {
            return this.getBlobPropertiesRecordRelativeOffset() != -1;
        }

        @Override
        public int getUpdateRecordRelativeOffset() {
            return this.buffer.getInt(20);
        }

        @Override
        public int getBlobEncryptionKeyRecordRelativeOffset() {
            return this.buffer.getInt(12);
        }

        @Override
        public int getBlobEncryptionKeyRecordSize() {
            if (this.hasEncryptionKeyRecord()) {
                return this.getBlobPropertiesRecordRelativeOffset() - this.getBlobEncryptionKeyRecordRelativeOffset();
            }
            return 0;
        }

        @Override
        public boolean hasEncryptionKeyRecord() {
            return this.getBlobEncryptionKeyRecordRelativeOffset() != -1;
        }

        @Override
        public int getUserMetadataRecordRelativeOffset() {
            return this.buffer.getInt(24);
        }

        @Override
        public int getUserMetadataRecordSize() {
            return this.getBlobRecordRelativeOffset() - this.getUserMetadataRecordRelativeOffset();
        }

        @Override
        public int getBlobRecordRelativeOffset() {
            return this.buffer.getInt(28);
        }

        @Override
        public long getBlobRecordSize() {
            int messageSizeExcludingBlobRecord = this.getBlobRecordRelativeOffset() - this.getPayloadRelativeOffset();
            return this.getMessageSize() - (long)messageSizeExcludingBlobRecord;
        }

        @Override
        public int getPayloadRelativeOffset() {
            if (this.isPutRecord()) {
                return this.hasEncryptionKeyRecord() ? this.getBlobEncryptionKeyRecordRelativeOffset() : this.getBlobPropertiesRecordRelativeOffset();
            }
            return this.getUpdateRecordRelativeOffset();
        }

        @Override
        public long getCrc() {
            return this.buffer.getLong(32);
        }

        @Override
        public void verifyHeader() throws MessageFormatException {
            this.verifyCrc();
            MessageHeader_Format_V3.checkHeaderConstraints(this.getMessageSize(), this.getLifeVersion(), this.getBlobEncryptionKeyRecordRelativeOffset(), this.getBlobPropertiesRecordRelativeOffset(), this.getUpdateRecordRelativeOffset(), this.getUserMetadataRecordRelativeOffset(), this.getBlobRecordRelativeOffset());
        }

        private void verifyCrc() throws MessageFormatException {
            Crc32 crc = new Crc32();
            crc.update(this.buffer.array(), 0, this.buffer.limit() - 8);
            if (crc.getValue() != this.getCrc()) {
                throw new MessageFormatException("Message header is corrupt", MessageFormatErrorCodes.Data_Corrupt);
            }
        }
    }

    public static class MessageHeader_Format_V2
    implements MessageHeader_Format {
        private ByteBuffer buffer;
        private static final Logger logger = LoggerFactory.getLogger(MessageHeader_Format_V2.class);
        public static final int Total_Size_Field_Offset_In_Bytes = 2;
        public static final int Total_Size_Field_Size_In_Bytes = 8;
        private static final int Number_Of_Relative_Offset_Fields = 5;
        public static final int Relative_Offset_Field_Sizes_In_Bytes = 4;
        public static final int Blob_Encryption_Key_Relative_Offset_Field_Offset_In_Bytes = 10;
        public static final int BlobProperties_Relative_Offset_Field_Offset_In_Bytes = 14;
        public static final int Update_Relative_Offset_Field_Offset_In_Bytes = 18;
        public static final int UserMetadata_Relative_Offset_Field_Offset_In_Bytes = 22;
        public static final int Blob_Relative_Offset_Field_Offset_In_Bytes = 26;
        public static final int Crc_Field_Offset_In_Bytes = 30;

        public static int getHeaderSize() {
            return 38;
        }

        public static void serializeHeader(ByteBuffer outputBuffer, long totalSize, int blobEncryptionKeyRecordRelativeOffset, int blobPropertiesRecordRelativeOffset, int updateRecordRelativeOffset, int userMetadataRecordRelativeOffset, int blobRecordRelativeOffset) throws MessageFormatException {
            MessageHeader_Format_V2.checkHeaderConstraints(totalSize, blobEncryptionKeyRecordRelativeOffset, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobRecordRelativeOffset);
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)2);
            outputBuffer.putLong(totalSize);
            outputBuffer.putInt(blobEncryptionKeyRecordRelativeOffset);
            outputBuffer.putInt(blobPropertiesRecordRelativeOffset);
            outputBuffer.putInt(updateRecordRelativeOffset);
            outputBuffer.putInt(userMetadataRecordRelativeOffset);
            outputBuffer.putInt(blobRecordRelativeOffset);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, MessageHeader_Format_V2.getHeaderSize() - 8);
            outputBuffer.putLong(crc.getValue());
            logger.trace("serializing header : version {} size {} blobencryptionkeyrecordrelativeoffset {} blobpropertiesrecordrelativeoffset {} updaterecordrelativeoffset {} usermetadatarecordrelativeoffset {} blobrecordrelativeoffset {} crc {}", new Object[]{(short)2, totalSize, blobEncryptionKeyRecordRelativeOffset, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobPropertiesRecordRelativeOffset, crc.getValue()});
        }

        private static void checkHeaderConstraints(long totalSize, int blobEncryptionKeyRecordRelativeOffset, int blobPropertiesRecordRelativeOffset, int updateRecordRelativeOffset, int userMetadataRecordRelativeOffset, int blobRecordRelativeOffset) throws MessageFormatException {
            if (totalSize <= 0L) {
                throw new MessageFormatException("checkHeaderConstraints - totalSize " + totalSize + " needs to be greater than 0", MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (blobPropertiesRecordRelativeOffset > 0 && (updateRecordRelativeOffset != -1 || userMetadataRecordRelativeOffset <= 0 || blobRecordRelativeOffset <= 0)) {
                throw new MessageFormatException("checkHeaderConstraints - blobPropertiesRecordRelativeOffset is greater than 0  but other properties do not satisfy constraints blobPropertiesRecordRelativeOffset " + blobPropertiesRecordRelativeOffset + " updateRecordRelativeOffset " + updateRecordRelativeOffset + " userMetadataRecordRelativeOffset " + userMetadataRecordRelativeOffset + " blobRecordRelativeOffset " + blobRecordRelativeOffset, MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (updateRecordRelativeOffset > 0 && (blobEncryptionKeyRecordRelativeOffset != -1 || blobPropertiesRecordRelativeOffset != -1 || userMetadataRecordRelativeOffset != -1 || blobRecordRelativeOffset != -1)) {
                throw new MessageFormatException("checkHeaderConstraints - updateRecordRelativeOffset is greater than 0  but other properties do not satisfy constraints blobEncryptionKeyRelativeOffset " + blobEncryptionKeyRecordRelativeOffset + " blobPropertiesRecordRelativeOffset " + blobPropertiesRecordRelativeOffset + " updateRecordRelativeOffset " + updateRecordRelativeOffset + " userMetadataRecordRelativeOffset " + userMetadataRecordRelativeOffset + " blobRecordRelativeOffset " + blobRecordRelativeOffset, MessageFormatErrorCodes.Header_Constraint_Error);
            }
        }

        public MessageHeader_Format_V2(ByteBuffer input) {
            this.buffer = input;
        }

        @Override
        public short getVersion() {
            return this.buffer.getShort(0);
        }

        @Override
        public boolean hasLifeVersion() {
            return false;
        }

        @Override
        public short getLifeVersion() {
            return 0;
        }

        @Override
        public long getMessageSize() {
            return this.buffer.getLong(2);
        }

        @Override
        public int getBlobPropertiesRecordRelativeOffset() {
            return this.buffer.getInt(14);
        }

        @Override
        public int getBlobPropertiesRecordSize() {
            return this.getUserMetadataRecordRelativeOffset() - this.getBlobPropertiesRecordRelativeOffset();
        }

        @Override
        public boolean isPutRecord() {
            return this.getBlobPropertiesRecordRelativeOffset() != -1;
        }

        @Override
        public int getUpdateRecordRelativeOffset() {
            return this.buffer.getInt(18);
        }

        @Override
        public int getBlobEncryptionKeyRecordRelativeOffset() {
            return this.buffer.getInt(10);
        }

        @Override
        public int getBlobEncryptionKeyRecordSize() {
            if (this.hasEncryptionKeyRecord()) {
                return this.getBlobPropertiesRecordRelativeOffset() - this.getBlobEncryptionKeyRecordRelativeOffset();
            }
            return 0;
        }

        @Override
        public boolean hasEncryptionKeyRecord() {
            return this.getBlobEncryptionKeyRecordRelativeOffset() != -1;
        }

        @Override
        public int getUserMetadataRecordRelativeOffset() {
            return this.buffer.getInt(22);
        }

        @Override
        public int getUserMetadataRecordSize() {
            return this.getBlobRecordRelativeOffset() - this.getUserMetadataRecordRelativeOffset();
        }

        @Override
        public int getBlobRecordRelativeOffset() {
            return this.buffer.getInt(26);
        }

        @Override
        public long getBlobRecordSize() {
            int messageSizeExcludingBlobRecord = this.getBlobRecordRelativeOffset() - this.getPayloadRelativeOffset();
            return this.getMessageSize() - (long)messageSizeExcludingBlobRecord;
        }

        @Override
        public int getPayloadRelativeOffset() {
            if (this.isPutRecord()) {
                return this.hasEncryptionKeyRecord() ? this.getBlobEncryptionKeyRecordRelativeOffset() : this.getBlobPropertiesRecordRelativeOffset();
            }
            return this.getUpdateRecordRelativeOffset();
        }

        @Override
        public long getCrc() {
            return this.buffer.getLong(30);
        }

        @Override
        public void verifyHeader() throws MessageFormatException {
            this.verifyCrc();
            MessageHeader_Format_V2.checkHeaderConstraints(this.getMessageSize(), this.getBlobEncryptionKeyRecordRelativeOffset(), this.getBlobPropertiesRecordRelativeOffset(), this.getUpdateRecordRelativeOffset(), this.getUserMetadataRecordRelativeOffset(), this.getBlobRecordRelativeOffset());
        }

        private void verifyCrc() throws MessageFormatException {
            Crc32 crc = new Crc32();
            crc.update(this.buffer.array(), 0, this.buffer.limit() - 8);
            if (crc.getValue() != this.getCrc()) {
                throw new MessageFormatException("Message header is corrupt", MessageFormatErrorCodes.Data_Corrupt);
            }
        }
    }

    public static class MessageHeader_Format_V1
    implements MessageHeader_Format {
        private ByteBuffer buffer;
        private static final Logger logger = LoggerFactory.getLogger(MessageHeader_Format_V1.class);
        public static final int Total_Size_Field_Offset_In_Bytes = 2;
        public static final int Total_Size_Field_Size_In_Bytes = 8;
        private static final int Number_Of_Relative_Offset_Fields = 4;
        public static final int Relative_Offset_Field_Sizes_In_Bytes = 4;
        public static final int BlobProperties_Relative_Offset_Field_Offset_In_Bytes = 10;
        public static final int Update_Relative_Offset_Field_Offset_In_Bytes = 14;
        public static final int UserMetadata_Relative_Offset_Field_Offset_In_Bytes = 18;
        public static final int Blob_Relative_Offset_Field_Offset_In_Bytes = 22;
        public static final int Crc_Field_Offset_In_Bytes = 26;

        public static int getHeaderSize() {
            return 34;
        }

        public static void serializeHeader(ByteBuffer outputBuffer, long totalSize, int blobPropertiesRecordRelativeOffset, int updateRecordRelativeOffset, int userMetadataRecordRelativeOffset, int blobRecordRelativeOffset) throws MessageFormatException {
            MessageHeader_Format_V1.checkHeaderConstraints(totalSize, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobRecordRelativeOffset);
            int startOffset = outputBuffer.position();
            outputBuffer.putShort((short)1);
            outputBuffer.putLong(totalSize);
            outputBuffer.putInt(blobPropertiesRecordRelativeOffset);
            outputBuffer.putInt(updateRecordRelativeOffset);
            outputBuffer.putInt(userMetadataRecordRelativeOffset);
            outputBuffer.putInt(blobRecordRelativeOffset);
            Crc32 crc = new Crc32();
            crc.update(outputBuffer.array(), startOffset, MessageHeader_Format_V1.getHeaderSize() - 8);
            outputBuffer.putLong(crc.getValue());
            logger.trace("serializing header : version {} size {} blobpropertiesrecordrelativeoffset {} updaterecordrelativeoffset {} usermetadatarecordrelativeoffset {} blobrecordrelativeoffset {} crc {}", new Object[]{(short)1, totalSize, blobPropertiesRecordRelativeOffset, updateRecordRelativeOffset, userMetadataRecordRelativeOffset, blobPropertiesRecordRelativeOffset, crc.getValue()});
        }

        private static void checkHeaderConstraints(long totalSize, int blobPropertiesRecordRelativeOffset, int updateRecordRelativeOffset, int userMetadataRecordRelativeOffset, int blobRecordRelativeOffset) throws MessageFormatException {
            if (totalSize <= 0L) {
                throw new MessageFormatException("checkHeaderConstraints - totalSize " + totalSize + " needs to be greater than 0", MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (blobPropertiesRecordRelativeOffset > 0 && (updateRecordRelativeOffset != -1 || userMetadataRecordRelativeOffset <= 0 || blobRecordRelativeOffset <= 0)) {
                throw new MessageFormatException("checkHeaderConstraints - blobPropertiesRecordRelativeOffset is greater than 0  but other properties do not satisfy constraints blobPropertiesRecordRelativeOffset " + blobPropertiesRecordRelativeOffset + " updateRecordRelativeOffset " + updateRecordRelativeOffset + " userMetadataRecordRelativeOffset " + userMetadataRecordRelativeOffset + " blobRecordRelativeOffset " + blobRecordRelativeOffset, MessageFormatErrorCodes.Header_Constraint_Error);
            }
            if (updateRecordRelativeOffset > 0 && (blobPropertiesRecordRelativeOffset != -1 || userMetadataRecordRelativeOffset != -1 || blobRecordRelativeOffset != -1)) {
                throw new MessageFormatException("checkHeaderConstraints - updateRecordRelativeOffset is greater than 0  but other properties do not satisfy constraints blobPropertiesRecordRelativeOffset " + blobPropertiesRecordRelativeOffset + " updateRecordRelativeOffset " + updateRecordRelativeOffset + " userMetadataRecordRelativeOffset " + userMetadataRecordRelativeOffset + " blobRecordRelativeOffset " + blobRecordRelativeOffset, MessageFormatErrorCodes.Header_Constraint_Error);
            }
        }

        public MessageHeader_Format_V1(ByteBuffer input) {
            this.buffer = input;
        }

        @Override
        public short getVersion() {
            return this.buffer.getShort(0);
        }

        @Override
        public boolean hasLifeVersion() {
            return false;
        }

        @Override
        public short getLifeVersion() {
            return 0;
        }

        @Override
        public boolean isPutRecord() {
            return this.getBlobPropertiesRecordRelativeOffset() != -1;
        }

        @Override
        public int getPayloadRelativeOffset() {
            return this.isPutRecord() ? this.getBlobPropertiesRecordRelativeOffset() : this.getUpdateRecordRelativeOffset();
        }

        @Override
        public long getMessageSize() {
            return this.buffer.getLong(2);
        }

        @Override
        public int getBlobPropertiesRecordRelativeOffset() {
            return this.buffer.getInt(10);
        }

        @Override
        public int getBlobPropertiesRecordSize() {
            return this.getUserMetadataRecordRelativeOffset() - this.getBlobPropertiesRecordRelativeOffset();
        }

        @Override
        public int getUpdateRecordRelativeOffset() {
            return this.buffer.getInt(14);
        }

        @Override
        public int getBlobEncryptionKeyRecordRelativeOffset() {
            return -1;
        }

        @Override
        public int getBlobEncryptionKeyRecordSize() {
            return 0;
        }

        @Override
        public boolean hasEncryptionKeyRecord() {
            return false;
        }

        @Override
        public int getUserMetadataRecordRelativeOffset() {
            return this.buffer.getInt(18);
        }

        @Override
        public int getUserMetadataRecordSize() {
            return this.getBlobRecordRelativeOffset() - this.getUserMetadataRecordRelativeOffset();
        }

        @Override
        public int getBlobRecordRelativeOffset() {
            return this.buffer.getInt(22);
        }

        @Override
        public long getBlobRecordSize() {
            int messageSizeExcludingBlobRecord = this.getBlobRecordRelativeOffset() - this.getPayloadRelativeOffset();
            return this.getMessageSize() - (long)messageSizeExcludingBlobRecord;
        }

        @Override
        public long getCrc() {
            return this.buffer.getLong(26);
        }

        @Override
        public void verifyHeader() throws MessageFormatException {
            this.verifyCrc();
            MessageHeader_Format_V1.checkHeaderConstraints(this.getMessageSize(), this.getBlobPropertiesRecordRelativeOffset(), this.getUpdateRecordRelativeOffset(), this.getUserMetadataRecordRelativeOffset(), this.getBlobRecordRelativeOffset());
        }

        private void verifyCrc() throws MessageFormatException {
            Crc32 crc = new Crc32();
            crc.update(this.buffer.array(), 0, this.buffer.limit() - 8);
            if (crc.getValue() != this.getCrc()) {
                throw new MessageFormatException("Message header is corrupt", MessageFormatErrorCodes.Data_Corrupt);
            }
        }
    }

    public static interface MessageHeader_Format {
        public short getVersion();

        public boolean hasLifeVersion();

        public short getLifeVersion();

        public int getPayloadRelativeOffset();

        public long getMessageSize();

        public int getBlobPropertiesRecordRelativeOffset();

        public int getBlobPropertiesRecordSize();

        public int getUpdateRecordRelativeOffset();

        public int getBlobEncryptionKeyRecordRelativeOffset();

        public int getBlobEncryptionKeyRecordSize();

        public int getUserMetadataRecordRelativeOffset();

        public int getUserMetadataRecordSize();

        public int getBlobRecordRelativeOffset();

        public long getBlobRecordSize();

        public long getCrc();

        public void verifyHeader() throws MessageFormatException;

        public boolean hasEncryptionKeyRecord();

        public boolean isPutRecord();
    }
}

