/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobType;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.store.StoreKey;
import com.github.ambry.store.StoreKeyFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class HardDeleteRecoveryMetadata {
    private short headerVersion;
    private short userMetadataVersion;
    private int userMetadataSize;
    private short blobRecordVersion;
    private BlobType blobType;
    private long blobStreamSize;
    private StoreKey storeKey;

    HardDeleteRecoveryMetadata(short headerVersion, short userMetadataVersion, int userMetadataSize, short blobRecordVersion, BlobType blobType, long blobStreamSize, StoreKey storeKey) throws IOException {
        if (!(MessageFormatRecord.isValidHeaderVersion(headerVersion) && MessageFormatRecord.isValidUserMetadataVersion(userMetadataVersion) && MessageFormatRecord.isValidBlobRecordVersion(blobRecordVersion))) {
            throw new IOException("Unknown version during hard delete, headerVersion: " + headerVersion + " userMetadataVersion: " + userMetadataVersion + " blobRecordVersion: " + blobRecordVersion);
        }
        this.headerVersion = headerVersion;
        this.userMetadataVersion = userMetadataVersion;
        this.userMetadataSize = userMetadataSize;
        this.blobRecordVersion = blobRecordVersion;
        this.blobType = blobType;
        this.blobStreamSize = blobStreamSize;
        this.storeKey = storeKey;
    }

    HardDeleteRecoveryMetadata(byte[] hardDeleteRecoveryMetadataBytes, StoreKeyFactory factory) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(hardDeleteRecoveryMetadataBytes));
        this.headerVersion = stream.readShort();
        this.userMetadataVersion = stream.readShort();
        this.userMetadataSize = stream.readInt();
        this.blobRecordVersion = stream.readShort();
        this.blobType = this.blobRecordVersion == 2 ? BlobType.values()[stream.readShort()] : BlobType.DataBlob;
        this.blobStreamSize = stream.readLong();
        if (!(MessageFormatRecord.isValidHeaderVersion(this.headerVersion) && MessageFormatRecord.isValidUserMetadataVersion(this.userMetadataVersion) && MessageFormatRecord.isValidBlobRecordVersion(this.blobRecordVersion))) {
            throw new IOException("Unknown version during hard delete, headerVersion: " + this.headerVersion + " userMetadataVersion: " + this.userMetadataVersion + " blobRecordVersion: " + this.blobRecordVersion + " blobType " + this.blobType);
        }
        this.storeKey = factory.getStoreKey(stream);
    }

    StoreKey getStoreKey() {
        return this.storeKey;
    }

    short getHeaderVersion() {
        return this.headerVersion;
    }

    short getUserMetadataVersion() {
        return this.userMetadataVersion;
    }

    int getUserMetadataSize() {
        return this.userMetadataSize;
    }

    short getBlobRecordVersion() {
        return this.blobRecordVersion;
    }

    BlobType getBlobType() {
        return this.blobType;
    }

    long getBlobStreamSize() {
        return this.blobStreamSize;
    }

    byte[] toBytes() {
        byte[] bytes = new byte[10 + (this.blobRecordVersion == 2 ? 2 : 0) + 8 + this.storeKey.sizeInBytes()];
        ByteBuffer bufWrap = ByteBuffer.wrap(bytes);
        bufWrap.putShort(this.headerVersion);
        bufWrap.putShort(this.userMetadataVersion);
        bufWrap.putInt(this.userMetadataSize);
        bufWrap.putShort(this.blobRecordVersion);
        if (this.blobRecordVersion == 2) {
            bufWrap.putShort((short)this.blobType.ordinal());
        }
        bufWrap.putLong(this.blobStreamSize);
        bufWrap.put(this.storeKey.toBytes());
        return bytes;
    }
}

