/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.store;

import com.github.ambry.store.StoreErrorCodes;
import java.util.Objects;

public class StoreException
extends Exception {
    static final String INTERNAL_ERROR_STR = "a fault occurred in a recent unsafe memory access operation in compiled Java code";
    static final String IO_ERROR_STR = "Input/output error";
    private static final long serialVersionUID = 1L;
    private final StoreErrorCodes error;

    public StoreException(String message, StoreErrorCodes error) {
        super(message);
        this.error = error;
    }

    public StoreException(String message, Throwable e, StoreErrorCodes error) {
        super(message, e);
        this.error = error;
    }

    public StoreException(Throwable e, StoreErrorCodes error) {
        super(e);
        this.error = error;
    }

    public StoreErrorCodes getErrorCode() {
        return this.error;
    }

    public static StoreErrorCodes resolveErrorCode(Throwable t) {
        return Objects.equals(t.getMessage(), IO_ERROR_STR) || Objects.equals(t.getMessage(), INTERNAL_ERROR_STR) ? StoreErrorCodes.IOError : StoreErrorCodes.Unknown_Error;
    }
}

