/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.server;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonPropertyOrder;

@JsonPropertyOrder(value={"value", "subMap"})
public class StatsSnapshot {
    private long value;
    private Map<String, StatsSnapshot> subMap;

    public static void aggregate(StatsSnapshot baseSnapshot, StatsSnapshot newSnapshot) {
        baseSnapshot.setValue(baseSnapshot.getValue() + newSnapshot.getValue());
        if (baseSnapshot.getSubMap() == null) {
            baseSnapshot.setSubMap(newSnapshot.getSubMap());
        } else if (newSnapshot.getSubMap() != null) {
            for (Map.Entry<String, StatsSnapshot> entry : newSnapshot.getSubMap().entrySet()) {
                if (!baseSnapshot.getSubMap().containsKey(entry.getKey())) {
                    baseSnapshot.getSubMap().put(entry.getKey(), new StatsSnapshot(0L, null));
                }
                StatsSnapshot.aggregate(baseSnapshot.getSubMap().get(entry.getKey()), entry.getValue());
            }
        }
    }

    public StatsSnapshot(Long value, Map<String, StatsSnapshot> subMap) {
        this.value = value;
        this.subMap = subMap;
    }

    public StatsSnapshot() {
    }

    public long getValue() {
        return this.value;
    }

    @JsonAnyGetter
    public Map<String, StatsSnapshot> getSubMap() {
        return this.subMap;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setSubMap(Map<String, StatsSnapshot> subMap) {
        this.subMap = subMap;
    }

    @JsonAnySetter
    public void add(String str, StatsSnapshot statsSnapshot) {
        this.subMap = this.subMap == null ? new HashMap() : this.subMap;
        this.subMap.put(str, statsSnapshot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsSnapshot that = (StatsSnapshot)o;
        if (this.value != that.value) {
            return false;
        }
        return this.subMap != null ? this.subMap.equals(that.subMap) : that.subMap == null;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.subMap != null ? this.subMap.hashCode() : 0);
        return result;
    }
}

