/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.router.Callback;
import com.github.ambry.router.ChunkInfo;
import com.github.ambry.router.GetBlobOptions;
import com.github.ambry.router.GetBlobResult;
import com.github.ambry.router.PutBlobOptions;
import com.github.ambry.router.ReadableStreamChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;

public interface Router
extends Closeable {
    public Future<GetBlobResult> getBlob(String var1, GetBlobOptions var2, Callback<GetBlobResult> var3);

    public Future<String> putBlob(BlobProperties var1, byte[] var2, ReadableStreamChannel var3, PutBlobOptions var4, Callback<String> var5);

    public Future<String> stitchBlob(BlobProperties var1, byte[] var2, List<ChunkInfo> var3, Callback<String> var4);

    public Future<Void> deleteBlob(String var1, String var2, Callback<Void> var3);

    public Future<Void> updateBlobTtl(String var1, String var2, long var3, Callback<Void> var5);

    @Override
    public void close() throws IOException;

    default public Future<GetBlobResult> getBlob(String blobId, GetBlobOptions options) {
        return this.getBlob(blobId, options, null);
    }

    default public Future<String> stitchBlob(BlobProperties blobProperties, byte[] userMetadata, List<ChunkInfo> chunksToStitch) {
        return this.stitchBlob(blobProperties, userMetadata, chunksToStitch, null);
    }

    default public Future<String> putBlob(BlobProperties blobProperties, byte[] userMetadata, ReadableStreamChannel channel, PutBlobOptions options) {
        return this.putBlob(blobProperties, userMetadata, channel, options, null);
    }

    default public Future<Void> deleteBlob(String blobId, String serviceId) {
        return this.deleteBlob(blobId, serviceId, null);
    }

    default public Future<Void> updateBlobTtl(String blobId, String serviceId, long expiresAtMs) {
        return this.updateBlobTtl(blobId, serviceId, expiresAtMs, null);
    }
}

