/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import com.github.ambry.protocol.GetOption;
import com.github.ambry.router.ByteRange;

public class GetBlobOptions {
    private final OperationType operationType;
    private final GetOption getOption;
    private final ByteRange range;
    private final boolean rawMode;
    private final int blobSegmentIdx;
    public static int NO_BLOB_SEGMENT_IDX_SPECIFIED = -1;

    GetBlobOptions(OperationType operationType, GetOption getOption, ByteRange range, boolean rawMode, int blobSegmentIdx) {
        if (operationType == null || getOption == null) {
            throw new IllegalArgumentException("operationType and getOption must be defined");
        }
        if (rawMode && range != null) {
            throw new IllegalArgumentException("Raw mode and range cannot be used together");
        }
        if (rawMode && operationType != OperationType.All) {
            throw new IllegalArgumentException("Raw mode can be used only with OperationType.ALL");
        }
        this.operationType = operationType;
        this.getOption = getOption;
        this.range = range;
        this.rawMode = rawMode;
        this.blobSegmentIdx = blobSegmentIdx;
    }

    public boolean isRawMode() {
        return this.rawMode;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public GetOption getGetOption() {
        return this.getOption;
    }

    public ByteRange getRange() {
        return this.range;
    }

    public int getBlobSegmentIdx() {
        return this.blobSegmentIdx;
    }

    public boolean hasBlobSegmentIdx() {
        return this.blobSegmentIdx != NO_BLOB_SEGMENT_IDX_SPECIFIED;
    }

    public String toString() {
        return "GetBlobOptions{operationType=" + (Object)((Object)this.operationType) + ", getOption=" + (Object)((Object)this.getOption) + ", range=" + this.range + ", rawMode=" + this.rawMode + ", blobSegmentIdx=" + this.blobSegmentIdx + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBlobOptions that = (GetBlobOptions)o;
        if (this.operationType != that.operationType) {
            return false;
        }
        if (this.getOption != that.getOption) {
            return false;
        }
        if (this.rawMode != that.rawMode) {
            return false;
        }
        if (this.blobSegmentIdx != that.blobSegmentIdx) {
            return false;
        }
        return !(this.range == null ? that.range != null : !this.range.equals(that.range));
    }

    public int hashCode() {
        int result = this.operationType.hashCode();
        result = 31 * result + this.getOption.hashCode();
        result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.rawMode);
        result = 31 * result + this.blobSegmentIdx;
        return result;
    }

    public static enum OperationType {
        All,
        Data,
        BlobInfo;

    }
}

