/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureResult<T>
implements Future<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile Exception error;
    private volatile T result;

    public void done(T result, Exception error) {
        this.error = error;
        this.result = result;
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public T result() {
        return this.result;
    }

    public Exception error() {
        return this.error;
    }

    public boolean completed() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.completed();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.await();
        return this.resultOrThrow();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean occurred = this.await(timeout, unit);
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + TimeUnit.MILLISECONDS.convert(timeout, unit) + " ms.");
        }
        return this.resultOrThrow();
    }

    private T resultOrThrow() throws ExecutionException {
        if (this.error() != null) {
            throw new ExecutionException(this.error());
        }
        return this.result();
    }
}

