/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import java.util.Objects;

public class ChunkInfo {
    private final String blobId;
    private final long chunkSizeInBytes;
    private final long expirationTimeInMs;

    public ChunkInfo(String blobId, long chunkSizeInBytes, long expirationTimeInMs) {
        this.blobId = Objects.requireNonNull(blobId, "blobId cannot be null");
        this.chunkSizeInBytes = chunkSizeInBytes;
        this.expirationTimeInMs = expirationTimeInMs;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public long getChunkSizeInBytes() {
        return this.chunkSizeInBytes;
    }

    public long getExpirationTimeInMs() {
        return this.expirationTimeInMs;
    }

    public String toString() {
        return "ChunkInfo{blobId='" + this.blobId + '\'' + ", chunkSizeInBytes=" + this.chunkSizeInBytes + ", expirationTimeInMs=" + this.expirationTimeInMs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkInfo chunkInfo = (ChunkInfo)o;
        return this.chunkSizeInBytes == chunkInfo.chunkSizeInBytes && this.expirationTimeInMs == chunkInfo.expirationTimeInMs && Objects.equals(this.blobId, chunkInfo.blobId);
    }

    public int hashCode() {
        return this.blobId.hashCode();
    }
}

