/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import com.github.ambry.router.Callback;
import com.github.ambry.utils.AsyncOperationTracker;
import com.github.ambry.utils.ThrowingConsumer;

public class CallbackUtils {
    public static <T> Callback<T> chainCallback(AsyncOperationTracker asyncOperationTracker, Callback<?> failureCallback, ThrowingConsumer<? super T> successAction) {
        asyncOperationTracker.markOperationStart();
        return (result, exception) -> {
            try {
                asyncOperationTracker.markOperationEnd();
                if (exception == null) {
                    successAction.accept(result);
                }
            }
            catch (Exception e) {
                asyncOperationTracker.markCallbackProcessingError();
                exception = e;
            }
            finally {
                if (exception != null) {
                    failureCallback.onCompletion(null, exception);
                }
                asyncOperationTracker.markCallbackProcessingEnd();
            }
        };
    }
}

