/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import com.github.ambry.router.ByteRange;

public class ByteRanges {
    public static ByteRange fromOffsetRange(long startOffset, long endOffset) {
        if (startOffset < 0L || endOffset < startOffset) {
            throw new IllegalArgumentException("Invalid range offsets provided for ByteRange; startOffset=" + startOffset + ", endOffset=" + endOffset);
        }
        return new ClosedRange(startOffset, endOffset);
    }

    public static ByteRange fromStartOffset(long startOffset) {
        if (startOffset < 0L) {
            throw new IllegalArgumentException("Invalid range offsets provided for ByteRange; startOffset=" + startOffset);
        }
        return new OpenRange(startOffset);
    }

    public static ByteRange fromLastNBytes(long lastNBytes) {
        if (lastNBytes < 0L) {
            throw new IllegalArgumentException("Invalid range offsets provided for ByteRange; lastNBytes=" + lastNBytes);
        }
        return new SuffixRange(lastNBytes);
    }

    private ByteRanges() {
    }

    private static class SuffixRange
    extends ByteRange {
        private long lastNBytes;

        private SuffixRange(long lastNBytes) {
            this.lastNBytes = lastNBytes;
        }

        @Override
        public long getLastNBytes() {
            return this.lastNBytes;
        }

        @Override
        public long getRangeSize() {
            return this.lastNBytes;
        }

        @Override
        public ByteRange.ByteRangeType getType() {
            return ByteRange.ByteRangeType.LAST_N_BYTES;
        }

        @Override
        public ByteRange toResolvedByteRange(long totalSize) {
            if (totalSize < 0L) {
                throw new IllegalArgumentException("Invalid totalSize: " + totalSize + " for range: " + this);
            }
            return new ClosedRange(Math.max(totalSize - this.getLastNBytes(), 0L), totalSize - 1L);
        }

        @Override
        public String toString() {
            return "ByteRange{lastNBytes=" + this.lastNBytes + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SuffixRange that = (SuffixRange)o;
            return this.lastNBytes == that.lastNBytes;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.lastNBytes);
        }
    }

    private static class OpenRange
    extends ByteRange {
        private long startOffset;

        private OpenRange(long startOffset) {
            this.startOffset = startOffset;
        }

        @Override
        public long getStartOffset() {
            return this.startOffset;
        }

        @Override
        public ByteRange.ByteRangeType getType() {
            return ByteRange.ByteRangeType.FROM_START_OFFSET;
        }

        @Override
        public ByteRange toResolvedByteRange(long totalSize) {
            if (this.getStartOffset() >= totalSize) {
                throw new IllegalArgumentException("Invalid totalSize: " + totalSize + " for range: " + this);
            }
            return new ClosedRange(this.getStartOffset(), totalSize - 1L);
        }

        @Override
        public String toString() {
            return "ByteRange{startOffset=" + this.startOffset + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpenRange that = (OpenRange)o;
            return this.startOffset == that.startOffset;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.startOffset);
        }
    }

    private static class ClosedRange
    extends ByteRange {
        private long startOffset;
        private long endOffset;

        private ClosedRange(long startOffset, long endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        public long getStartOffset() {
            return this.startOffset;
        }

        @Override
        public long getEndOffset() {
            return this.endOffset;
        }

        @Override
        public long getRangeSize() {
            return this.getEndOffset() - this.getStartOffset() + 1L;
        }

        @Override
        public ByteRange.ByteRangeType getType() {
            return ByteRange.ByteRangeType.OFFSET_RANGE;
        }

        @Override
        public ByteRange toResolvedByteRange(long totalSize) {
            if (this.getStartOffset() >= totalSize) {
                throw new IllegalArgumentException("Invalid totalSize: " + totalSize + " for range: " + this);
            }
            return new ClosedRange(this.getStartOffset(), Math.min(this.getEndOffset(), totalSize - 1L));
        }

        @Override
        public String toString() {
            return "ByteRange{startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClosedRange that = (ClosedRange)o;
            return this.startOffset == that.startOffset && this.endOffset == that.endOffset;
        }

        @Override
        public int hashCode() {
            return 31 * Long.hashCode(this.startOffset) + Long.hashCode(this.endOffset);
        }
    }
}

