/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.router;

import com.github.ambry.router.Callback;
import com.github.ambry.router.FutureResult;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public interface AsyncWritableChannel
extends Channel {
    public Future<Long> write(ByteBuffer var1, Callback<Long> var2);

    default public Future<Long> write(ByteBuf src, Callback<Long> callback) {
        if (src == null) {
            throw new IllegalArgumentException("Source ByteBuf cannot be null");
        }
        int numBuffers = src.nioBufferCount();
        FutureResult<Long> futureResult = new FutureResult<Long>();
        Callback<Long> singleBufferCallback = (result, exception) -> {
            if (result != 0L) {
                src.readerIndex(src.readerIndex() + (int)result.longValue());
            }
            futureResult.done((Long)result, exception);
            if (callback != null) {
                callback.onCompletion((Long)result, exception);
            }
        };
        if (numBuffers < 1) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(src.readableBytes());
            src.getBytes(src.readerIndex(), byteBuffer);
            this.write(byteBuffer, singleBufferCallback);
        } else if (numBuffers == 1) {
            this.write(src.nioBuffer(), singleBufferCallback);
        } else {
            ByteBuffer[] buffers = src.nioBuffers();
            AtomicLong size = new AtomicLong(0L);
            AtomicInteger index = new AtomicInteger(0);
            AtomicBoolean callbackInvoked = new AtomicBoolean(false);
            Callback<Long> cb = (result, exception) -> {
                index.addAndGet(1);
                size.addAndGet((long)result);
                if (result != 0L) {
                    src.readerIndex(src.readerIndex() + (int)result.longValue());
                }
                if ((exception != null || index.get() == buffers.length) && callbackInvoked.compareAndSet(false, true)) {
                    futureResult.done(size.get(), exception);
                    if (callback != null) {
                        callback.onCompletion(size.get(), exception);
                    }
                }
            };
            for (int i = 0; i < buffers.length; ++i) {
                this.write(buffers[i], cb);
            }
        }
        return futureResult;
    }
}

