/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.rest;

import com.codahale.metrics.MetricRegistry;
import com.github.ambry.frontend.ContainerMetrics;
import com.github.ambry.rest.ResponseStatus;
import com.github.ambry.rest.RestRequestMetrics;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class RestRequestMetricsTracker {
    protected static final String DEFAULT_REQUEST_TYPE = "Unknown";
    private static RestRequestMetrics defaultMetrics;
    public final NioMetricsTracker nioMetricsTracker = new NioMetricsTracker();
    public final ScalingMetricsTracker scalingMetricsTracker = new ScalingMetricsTracker();
    private final AtomicBoolean metricsRecorded = new AtomicBoolean(false);
    private RestRequestMetrics metrics = defaultMetrics;
    private ContainerMetrics containerMetrics;
    private boolean failed = false;
    private boolean satisfied = true;
    private ResponseStatus responseStatus = ResponseStatus.Ok;

    public void markFailure() {
        this.failed = true;
    }

    public void markUnsatisfied() {
        this.satisfied = false;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void setResponseStatus(ResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
    }

    public void injectMetrics(RestRequestMetrics restRequestMetrics) {
        if (restRequestMetrics == null) {
            throw new IllegalArgumentException("RestRequestMetrics provided cannot be null");
        }
        this.metrics = restRequestMetrics;
    }

    public void injectContainerMetrics(ContainerMetrics containerMetrics) {
        this.containerMetrics = containerMetrics;
    }

    public void recordMetrics() {
        if (this.metrics != null) {
            if (this.metricsRecorded.compareAndSet(false, true)) {
                this.metrics.operationRate.mark();
                this.metrics.operationCount.inc();
                this.metrics.nioRequestProcessingTimeInMs.update(this.nioMetricsTracker.requestProcessingTimeInMs.get());
                this.metrics.nioResponseProcessingTimeInMs.update(this.nioMetricsTracker.responseProcessingTimeInMs.get());
                this.metrics.nioRoundTripTimeInMs.update(this.nioMetricsTracker.roundTripTimeInMs);
                this.metrics.nioTimeToFirstByteInMs.update(this.nioMetricsTracker.timeToFirstByteInMs);
                this.metrics.scRequestProcessingTimeInMs.update(this.scalingMetricsTracker.requestProcessingTimeInMs.get());
                this.metrics.scRequestProcessingWaitTimeInMs.update(this.scalingMetricsTracker.requestProcessingWaitTimeInMs.get());
                this.metrics.scResponseProcessingTimeInMs.update(this.scalingMetricsTracker.responseProcessingTimeInMs.get());
                this.metrics.scResponseProcessingWaitTimeInMs.update(this.scalingMetricsTracker.responseProcessingWaitTimeInMs.get());
                this.metrics.scRoundTripTimeInMs.update(this.scalingMetricsTracker.roundTripTimeInMs);
                if (this.failed) {
                    this.metrics.operationError.inc();
                }
                if (this.containerMetrics != null) {
                    this.containerMetrics.recordMetrics(this.nioMetricsTracker.roundTripTimeInMs, this.responseStatus);
                }
                if (this.satisfied) {
                    this.metrics.satisfiedRequestCount.inc();
                } else {
                    this.metrics.unsatisfiedRequestCount.inc();
                }
            }
        } else {
            throw new IllegalStateException("Could not record metrics because there is no metrics tracker");
        }
    }

    public long getRoundTripTimeInMs() {
        return this.nioMetricsTracker.roundTripTimeInMs;
    }

    public long getTimeToFirstByteInMs() {
        return this.nioMetricsTracker.timeToFirstByteInMs;
    }

    public static void setDefaults(MetricRegistry metricRegistry) {
        defaultMetrics = new RestRequestMetrics(RestRequestMetricsTracker.class, DEFAULT_REQUEST_TYPE, metricRegistry);
    }

    public static class ScalingMetricsTracker {
        private final AtomicLong requestProcessingTimeInMs = new AtomicLong(0L);
        private final AtomicLong requestProcessingWaitTimeInMs = new AtomicLong(0L);
        private final AtomicLong responseProcessingTimeInMs = new AtomicLong(0L);
        private final AtomicLong responseProcessingWaitTimeInMs = new AtomicLong(0L);
        private long requestReceivedTime = 0L;
        private long roundTripTimeInMs = 0L;

        public long addToRequestProcessingTime(long delta) {
            return this.requestProcessingTimeInMs.addAndGet(delta);
        }

        public long addToRequestProcessingWaitTime(long delta) {
            return this.requestProcessingWaitTimeInMs.addAndGet(delta);
        }

        public long addToResponseProcessingTime(long delta) {
            return this.responseProcessingTimeInMs.addAndGet(delta);
        }

        public long addToResponseProcessingWaitTime(long delta) {
            return this.responseProcessingWaitTimeInMs.addAndGet(delta);
        }

        public void markRequestReceived() {
            this.requestReceivedTime = System.currentTimeMillis();
        }

        public void markRequestCompleted() {
            if (this.requestReceivedTime == 0L) {
                throw new IllegalStateException("Request was marked completed without being marked received");
            }
            this.roundTripTimeInMs = System.currentTimeMillis() - this.requestReceivedTime;
        }
    }

    public static class NioMetricsTracker {
        private final AtomicLong requestProcessingTimeInMs = new AtomicLong(0L);
        private final AtomicLong responseProcessingTimeInMs = new AtomicLong(0L);
        private long requestReceivedTime = 0L;
        private long timeToFirstByteInMs = 0L;
        private long roundTripTimeInMs = 0L;

        public long addToRequestProcessingTime(long delta) {
            return this.requestProcessingTimeInMs.addAndGet(delta);
        }

        public long addToResponseProcessingTime(long delta) {
            return this.responseProcessingTimeInMs.addAndGet(delta);
        }

        public void markRequestReceived() {
            this.requestReceivedTime = System.currentTimeMillis();
        }

        public void markFirstByteSent() {
            if (this.requestReceivedTime == 0L) {
                throw new IllegalStateException("First response byte was marked as sent without request being marked received");
            }
            this.timeToFirstByteInMs = System.currentTimeMillis() - this.requestReceivedTime;
        }

        public void markRequestCompleted() {
            if (this.requestReceivedTime == 0L) {
                throw new IllegalStateException("Request was marked completed without being marked received");
            }
            this.roundTripTimeInMs = System.currentTimeMillis() - this.requestReceivedTime;
        }
    }
}

