/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.rest;

import com.github.ambry.rest.RestServiceErrorCode;

public enum ResponseStatus {
    Ok(200),
    Created(201),
    Accepted(202),
    PartialContent(206),
    NotModified(304),
    BadRequest(400),
    Unauthorized(401),
    Forbidden(403),
    NotFound(404),
    MethodNotAllowed(405),
    ProxyAuthenticationRequired(407),
    Gone(410),
    PreconditionFailed(412),
    RequestTooLarge(413),
    RangeNotSatisfiable(416),
    TooManyRequests(429),
    InternalServerError(500),
    ServiceUnavailable(503),
    InsufficientCapacity(507);

    private final int statusCode;

    private ResponseStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean isServerError() {
        return this.statusCode >= 500;
    }

    public static ResponseStatus getResponseStatus(RestServiceErrorCode restServiceErrorCode) {
        switch (restServiceErrorCode) {
            case RequestTooLarge: {
                return RequestTooLarge;
            }
            case Deleted: {
                return Gone;
            }
            case NotFound: {
                return NotFound;
            }
            case BadRequest: 
            case InvalidArgs: 
            case InvalidAccount: 
            case InvalidContainer: 
            case InvalidRequestState: 
            case MalformedRequest: 
            case MissingArgs: 
            case UnsupportedHttpMethod: {
                return BadRequest;
            }
            case ResourceDirty: 
            case AccessDenied: {
                return Forbidden;
            }
            case Unauthorized: {
                return Unauthorized;
            }
            case NotAllowed: {
                return MethodNotAllowed;
            }
            case ResourceScanInProgress: {
                return ProxyAuthenticationRequired;
            }
            case RangeNotSatisfiable: {
                return RangeNotSatisfiable;
            }
            case ServiceUnavailable: {
                return ServiceUnavailable;
            }
            case TooManyRequests: {
                return TooManyRequests;
            }
            case InsufficientCapacity: {
                return InsufficientCapacity;
            }
            case PreconditionFailed: {
                return PreconditionFailed;
            }
        }
        return InternalServerError;
    }
}

