/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.replication;

import com.github.ambry.clustermap.ReplicaType;
import com.github.ambry.config.ReplicationConfig;
import com.github.ambry.replication.FindTokenFactory;
import com.github.ambry.store.StoreKeyFactory;
import com.github.ambry.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindTokenHelper {
    private static final Logger logger = LoggerFactory.getLogger(FindTokenHelper.class);
    private final StoreKeyFactory storeKeyFactory;
    private final ReplicationConfig replicationConfig;
    private final Map<ReplicaType, FindTokenFactory> findTokenFactoryMap;

    public FindTokenHelper() {
        this.storeKeyFactory = null;
        this.replicationConfig = null;
        this.findTokenFactoryMap = null;
    }

    public FindTokenHelper(StoreKeyFactory storeKeyFactory, ReplicationConfig replicationConfig) throws ReflectiveOperationException {
        this.storeKeyFactory = storeKeyFactory;
        this.replicationConfig = replicationConfig;
        this.findTokenFactoryMap = new HashMap<ReplicaType, FindTokenFactory>();
        this.findTokenFactoryMap.put(ReplicaType.DISK_BACKED, (FindTokenFactory)Utils.getObj((String)replicationConfig.replicationStoreTokenFactory, (Object)storeKeyFactory));
        this.findTokenFactoryMap.put(ReplicaType.CLOUD_BACKED, (FindTokenFactory)Utils.getObj((String)replicationConfig.replicationCloudTokenFactory));
    }

    public FindTokenFactory getFindTokenFactoryFromReplicaType(ReplicaType replicaType) {
        if (!this.findTokenFactoryMap.containsKey((Object)replicaType)) {
            throw new IllegalArgumentException("Invalid replica type " + ((Object)((Object)replicaType)).getClass());
        }
        return this.findTokenFactoryMap.get((Object)replicaType);
    }
}

