/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.network;

import com.codahale.metrics.Histogram;

public class ServerNetworkResponseMetrics {
    private final Histogram responseQueueTime;
    private final Histogram responseSendTime;
    private final Histogram responseTotalTime;
    private final Histogram responseSendTimeBySize;
    private final Histogram responseTotalTimeBySize;
    private long timeSpentTillNow;

    public ServerNetworkResponseMetrics(Histogram responseQueueTime, Histogram responseSendTime, Histogram responseTotalTime, Histogram responseSendTimeBySize, Histogram responseTotalTimeBySize, long timeSpentTillNow) {
        this.responseQueueTime = responseQueueTime;
        this.responseSendTime = responseSendTime;
        this.responseTotalTime = responseTotalTime;
        this.responseSendTimeBySize = responseSendTimeBySize;
        this.responseTotalTimeBySize = responseTotalTimeBySize;
        this.timeSpentTillNow = timeSpentTillNow;
    }

    public void updateQueueTime(long value) {
        this.responseQueueTime.update(value);
        this.timeSpentTillNow += value;
    }

    public void updateSendTime(long value) {
        this.responseSendTime.update(value);
        if (this.responseSendTimeBySize != null) {
            this.responseSendTimeBySize.update(value);
        }
        this.timeSpentTillNow += value;
        this.responseTotalTime.update(this.timeSpentTillNow);
        if (this.responseTotalTimeBySize != null) {
            this.responseTotalTimeBySize.update(this.timeSpentTillNow);
        }
    }
}

