/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.network;

import com.github.ambry.clustermap.DataNodeId;
import com.github.ambry.network.NetworkClientErrorCode;
import com.github.ambry.network.RequestInfo;
import com.github.ambry.utils.AbstractByteBufHolder;
import io.netty.buffer.ByteBuf;

public class ResponseInfo
extends AbstractByteBufHolder<ResponseInfo> {
    private final RequestInfo requestInfo;
    private final NetworkClientErrorCode error;
    private final DataNodeId dataNode;
    private ByteBuf content;

    public ResponseInfo(RequestInfo requestInfo, NetworkClientErrorCode error, ByteBuf content) {
        this(requestInfo, error, content, requestInfo == null ? null : requestInfo.getReplicaId().getDataNodeId());
    }

    public ResponseInfo(RequestInfo requestInfo, NetworkClientErrorCode error, ByteBuf content, DataNodeId dataNode) {
        this.requestInfo = requestInfo;
        this.error = error;
        this.content = content;
        this.dataNode = dataNode;
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public NetworkClientErrorCode getError() {
        return this.error;
    }

    public DataNodeId getDataNode() {
        return this.dataNode;
    }

    public String toString() {
        return "ResponseInfo{requestInfo=" + this.requestInfo + ", error=" + (Object)((Object)this.error) + ", response=" + this.content + ", dataNode=" + this.dataNode + '}';
    }

    public ByteBuf content() {
        return this.content;
    }

    public ResponseInfo replace(ByteBuf content) {
        return new ResponseInfo(this.requestInfo, this.error, content, this.dataNode);
    }
}

