/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.network;

import com.github.ambry.utils.AbstractByteBufHolder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedNettyByteBufReceive
extends AbstractByteBufHolder<BoundedNettyByteBufReceive> {
    private ByteBuf buffer = null;
    private ByteBuf sizeBuffer = null;
    private long sizeToRead = 0L;
    private long sizeRead = 0L;
    private static final Logger logger = LoggerFactory.getLogger(BoundedNettyByteBufReceive.class);

    public BoundedNettyByteBufReceive() {
    }

    BoundedNettyByteBufReceive(ByteBuf buffer, long sizeToRead) {
        this.buffer = Objects.requireNonNull(buffer);
        this.sizeToRead = sizeToRead;
    }

    public boolean isReadComplete() {
        return this.buffer != null && this.sizeRead >= this.sizeToRead;
    }

    private int readBytesFromReadableByteChannel(ReadableByteChannel channel, ByteBuf buffer) throws IOException {
        int n = channel.read(buffer.nioBuffer(buffer.writerIndex(), buffer.capacity() - buffer.writerIndex()));
        if (n > 0) {
            buffer.writerIndex(buffer.writerIndex() + n);
        }
        return n;
    }

    public long readFrom(ReadableByteChannel channel) throws IOException {
        long bytesRead = 0L;
        if (this.buffer == null) {
            if (this.sizeBuffer == null) {
                this.sizeBuffer = ByteBufAllocator.DEFAULT.heapBuffer(8);
            }
            try {
                bytesRead = this.readBytesFromReadableByteChannel(channel, this.sizeBuffer);
                if (bytesRead < 0L) {
                    throw new EOFException();
                }
            }
            catch (IOException e) {
                this.sizeBuffer.release();
                this.sizeBuffer = null;
                throw e;
            }
            if (this.sizeBuffer.writerIndex() == this.sizeBuffer.capacity()) {
                this.sizeToRead = this.sizeBuffer.readLong();
                this.sizeRead += 8L;
                this.sizeBuffer.release();
                this.buffer = ByteBufAllocator.DEFAULT.heapBuffer((int)this.sizeToRead - 8);
            }
        }
        if (this.buffer != null && this.sizeRead < this.sizeToRead) {
            long bytesReadFromChannel;
            try {
                bytesReadFromChannel = this.readBytesFromReadableByteChannel(channel, this.buffer);
                if (bytesReadFromChannel < 0L) {
                    throw new EOFException();
                }
            }
            catch (IOException e) {
                this.buffer.release();
                this.buffer = null;
                throw e;
            }
            this.sizeRead += bytesReadFromChannel;
            bytesRead += bytesReadFromChannel;
        }
        logger.trace("size read from channel {}", (Object)this.sizeRead);
        return bytesRead;
    }

    public long sizeRead() {
        return this.sizeRead;
    }

    public ByteBuf content() {
        return this.buffer;
    }

    public BoundedNettyByteBufReceive replace(ByteBuf content) {
        return new BoundedNettyByteBufReceive(content, this.sizeToRead);
    }
}

