/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.utils.SystemTime;

public class BlobProperties {
    private final String serviceId;
    private final String ownerId;
    private final String contentType;
    private final boolean isPrivate;
    private final long creationTimeInMs;
    private final short accountId;
    private final short containerId;
    private final boolean isEncrypted;
    private long blobSize;
    private long timeToLiveInSeconds;
    private final String externalAssetTag;

    public BlobProperties(long blobSize, String serviceId, short accountId, short containerId, boolean isEncrypted) {
        this(blobSize, serviceId, null, null, false, -1L, SystemTime.getInstance().milliseconds(), accountId, containerId, isEncrypted, null);
    }

    public BlobProperties(long blobSize, String serviceId, String ownerId, String contentType, boolean isPrivate, long timeToLiveInSeconds, short accountId, short containerId, boolean isEncrypted, String externalAssetTag) {
        this(blobSize, serviceId, ownerId, contentType, isPrivate, timeToLiveInSeconds, SystemTime.getInstance().milliseconds(), accountId, containerId, isEncrypted, externalAssetTag);
    }

    public BlobProperties(long blobSize, String serviceId, String ownerId, String contentType, boolean isPrivate, long timeToLiveInSeconds, long creationTimeInMs, short accountId, short containerId, boolean isEncrypted, String externalAssetTag) {
        this.blobSize = blobSize;
        this.serviceId = serviceId;
        this.ownerId = ownerId;
        this.contentType = contentType;
        this.isPrivate = isPrivate;
        this.creationTimeInMs = creationTimeInMs;
        this.timeToLiveInSeconds = timeToLiveInSeconds;
        this.accountId = accountId;
        this.containerId = containerId;
        this.isEncrypted = isEncrypted;
        this.externalAssetTag = externalAssetTag;
    }

    public long getTimeToLiveInSeconds() {
        return this.timeToLiveInSeconds;
    }

    public long getBlobSize() {
        return this.blobSize;
    }

    @Deprecated
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getCreationTimeInMs() {
        return this.creationTimeInMs;
    }

    public short getAccountId() {
        return this.accountId;
    }

    public short getContainerId() {
        return this.containerId;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String getExternalAssetTag() {
        return this.externalAssetTag;
    }

    public void setTimeToLiveInSeconds(long timeToLiveInSeconds) {
        this.timeToLiveInSeconds = timeToLiveInSeconds;
    }

    public void setBlobSize(long blobSize) {
        this.blobSize = blobSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlobProperties[");
        sb.append("BlobSize=").append(this.getBlobSize());
        if (this.getContentType() != null) {
            sb.append(", ").append("ContentType=").append(this.getContentType());
        } else {
            sb.append(", ").append("ContentType=Null");
        }
        if (this.getOwnerId() != null) {
            sb.append(", ").append("OwnerId=").append(this.getOwnerId());
        } else {
            sb.append(", ").append("OwnerId=Null");
        }
        if (this.getServiceId() != null) {
            sb.append(", ").append("ServiceId=").append(this.getServiceId());
        } else {
            sb.append(", ").append("ServiceId=Null");
        }
        sb.append(", ").append("IsPrivate=").append(this.isPrivate());
        sb.append(", ").append("CreationTimeInMs=").append(this.getCreationTimeInMs());
        if (this.getTimeToLiveInSeconds() != -1L) {
            sb.append(", ").append("TimeToLiveInSeconds=").append(this.getTimeToLiveInSeconds());
        } else {
            sb.append(", ").append("TimeToLiveInSeconds=Infinite");
        }
        sb.append(", ").append("AccountId=").append(this.getAccountId());
        sb.append(", ").append("ContainerId=").append(this.getContainerId());
        sb.append(", ").append("IsEncrypted=").append(this.isEncrypted());
        sb.append(", ").append("externalAssetTag=").append(this.getExternalAssetTag());
        sb.append("]");
        return sb.toString();
    }
}

