/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.frontend;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.github.ambry.rest.ResponseStatus;

public class ContainerMetrics {
    private static final String SEPARATOR = "___";
    private final Histogram roundTripTimeInMs;
    private final Counter successCount;
    private final Counter redirectionCount;
    private final Counter clientErrorCount;
    private final Counter serverErrorCount;
    private final Counter badRequestCount;
    private final Counter unauthorizedCount;
    private final Counter forbiddenCount;
    private final Counter notFoundCount;
    private final Counter goneCount;

    ContainerMetrics(String accountName, String containerName, String operationType, MetricRegistry metricRegistry) {
        String metricPrefix = accountName + SEPARATOR + containerName + SEPARATOR + operationType;
        this.roundTripTimeInMs = metricRegistry.histogram(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "RoundTripTimeInMs"}));
        this.successCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "SuccessCount"}));
        this.redirectionCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "RedirectionCount"}));
        this.clientErrorCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "ClientErrorCount"}));
        this.serverErrorCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "ServerErrorCount"}));
        this.badRequestCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "BadRequestCount"}));
        this.unauthorizedCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "UnauthorizedCount"}));
        this.forbiddenCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "ForbiddenCount"}));
        this.notFoundCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "NotFoundCount"}));
        this.goneCount = metricRegistry.counter(MetricRegistry.name(ContainerMetrics.class, (String[])new String[]{metricPrefix + "GoneCount"}));
    }

    public void recordMetrics(long roundTripTimeInMs, ResponseStatus responseStatus) {
        this.roundTripTimeInMs.update(roundTripTimeInMs);
        if (responseStatus.isSuccess()) {
            this.successCount.inc();
        } else if (responseStatus.isRedirection()) {
            this.redirectionCount.inc();
        } else if (responseStatus.isClientError()) {
            this.clientErrorCount.inc();
            switch (responseStatus) {
                case BadRequest: {
                    this.badRequestCount.inc();
                    break;
                }
                case Unauthorized: {
                    this.unauthorizedCount.inc();
                    break;
                }
                case Forbidden: {
                    this.forbiddenCount.inc();
                    break;
                }
                case NotFound: {
                    this.notFoundCount.inc();
                    break;
                }
                case Gone: {
                    this.goneCount.inc();
                }
            }
        } else if (responseStatus.isServerError()) {
            this.serverErrorCount.inc();
        }
    }
}

