/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifiableProperties {
    private final HashSet<String> referenceSet = new HashSet();
    private final Properties props;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public VerifiableProperties(Properties props) {
        this.props = props;
    }

    public boolean containsKey(String name) {
        return this.props.containsKey(name);
    }

    public String getProperty(String name) {
        String value = this.props.getProperty(name);
        this.referenceSet.add(name);
        return value;
    }

    public int getInt(String name) {
        return Integer.parseInt(this.getString(name));
    }

    public int getIntInRange(String name, int start, int end) {
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Missing required property '" + name + "'");
        }
        return this.getIntInRange(name, -1, start, end);
    }

    public int getInt(String name, int defaultVal) {
        return this.getIntInRange(name, defaultVal, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public Integer getInteger(String name, Integer defaultVal) {
        Integer v = this.containsKey(name) ? Integer.valueOf(Integer.parseInt(this.getProperty(name))) : defaultVal;
        return v;
    }

    public Short getShort(String name, Short defaultVal) {
        return this.getShortInRange(name, defaultVal, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    public int getIntInRange(String name, int defaultVal, int start, int end) {
        int v;
        int n = v = this.containsKey(name) ? Integer.parseInt(this.getProperty(name)) : defaultVal;
        if (v >= start && v <= end) {
            return v;
        }
        throw new IllegalArgumentException(name + " has value " + v + " which is not in the range " + start + "-" + end + ".");
    }

    public Short getShortInRange(String name, Short defaultVal, Short start, Short end) {
        Short v = this.containsKey(name) ? Short.parseShort(this.getProperty(name)) : defaultVal;
        if (v >= start && v <= end) {
            return v;
        }
        throw new IllegalArgumentException(name + " has value " + v + " which is not in the range " + start + "-" + end + ".");
    }

    public Short getShortFromAllowedValues(String name, Short defaultVal, Short[] allowedValues) {
        Short v;
        List<Short> allowedValuesList = Arrays.asList(allowedValues);
        if (allowedValuesList.contains(v = Short.valueOf(this.containsKey(name) ? Short.parseShort(this.getProperty(name)) : defaultVal))) {
            return v;
        }
        throw new IllegalArgumentException(name + " has value " + v + " which is not among the allowed values: " + allowedValuesList);
    }

    public Double getDoubleInRange(String name, Double defaultVal, Double start, Double end) {
        Double v = this.containsKey(name) ? Double.valueOf(Double.parseDouble(this.getProperty(name))) : defaultVal;
        BigDecimal startDecimal = new BigDecimal(start);
        BigDecimal endDecimal = new BigDecimal(end);
        BigDecimal value = new BigDecimal(v);
        if (value.compareTo(startDecimal) >= 0 && value.compareTo(endDecimal) <= 0) {
            return v;
        }
        throw new IllegalArgumentException(name + " has value " + v + " which is not in range " + start + "-" + end + ".");
    }

    public long getLong(String name) {
        return Long.parseLong(this.getString(name));
    }

    public long getLong(String name, long defaultVal) {
        return this.getLongInRange(name, defaultVal, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public long getLongInRange(String name, long defaultVal, long start, long end) {
        long v;
        long l = v = this.containsKey(name) ? Long.parseLong(this.getProperty(name)) : defaultVal;
        if (v >= start && v <= end) {
            return v;
        }
        throw new IllegalArgumentException(name + " has value " + v + " which is not in the range " + start + "-" + end + ".");
    }

    public double getDouble(String name) {
        return Double.parseDouble(this.getString(name));
    }

    public double getDouble(String name, double defaultVal) {
        return this.containsKey(name) ? this.getDouble(name) : defaultVal;
    }

    public boolean getBoolean(String name, boolean defaultVal) {
        if (!this.containsKey(name)) {
            return defaultVal;
        }
        String v = this.getProperty(name);
        if (v.compareTo("true") == 0 || v.compareTo("false") == 0) {
            return Boolean.parseBoolean(v);
        }
        throw new IllegalArgumentException(name + " has value " + v + " which is not true or false.");
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getString(name));
    }

    public String getString(String name, String defaultVal) {
        return this.containsKey(name) ? this.getProperty(name) : defaultVal;
    }

    public String getString(String name) {
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Missing required property '" + name + "'");
        }
        return this.getProperty(name);
    }

    public void verify() {
        this.logger.info("Verifying properties");
        Enumeration<?> keys = this.props.propertyNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!this.referenceSet.contains(key)) {
                this.logger.warn("Property {} is not valid", key);
                continue;
            }
            this.logger.info("Property {} is overridden to {}", key, (Object)this.props.getProperty(key.toString()));
        }
    }

    public String toString() {
        return this.props.toString();
    }
}

