/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import com.github.ambry.store.IndexMemState;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class StoreConfig {
    @Config(value={"store.key.factory"})
    @Default(value="com.github.ambry.commons.BlobIdFactory")
    public final String storeKeyFactory;
    @Config(value={"store.data.flush.interval.seconds"})
    @Default(value="60")
    public final long storeDataFlushIntervalSeconds;
    @Config(value={"store.index.max.memory.size.bytes"})
    @Default(value="20971520")
    public final int storeIndexMaxMemorySizeBytes;
    @Config(value={"store.data.flush.delay.seconds"})
    @Default(value="5")
    public final int storeDataFlushDelaySeconds;
    @Config(value={"store.index.max.number.of.inmem.elements"})
    @Default(value="10000")
    public final int storeIndexMaxNumberOfInmemElements;
    @Config(value={"store.max.number.of.entries.to.return.from.journal"})
    @Default(value="5000")
    public final int storeMaxNumberOfEntriesToReturnFromJournal;
    @Config(value={"store.index.bloom.max.false.positive.probability"})
    @Default(value="0.01")
    public final double storeIndexBloomMaxFalsePositiveProbability;
    @Config(value={"store.deleted.message.retention.days"})
    @Default(value="7")
    public final int storeDeletedMessageRetentionDays;
    @Config(value={"store.hard.delete.operations.bytes.per.sec"})
    @Default(value="100*1024")
    public final int storeHardDeleteOperationsBytesPerSec;
    @Config(value={"store.compaction.operations.bytes.per.sec"})
    @Default(value="1*1024*1024")
    public final int storeCompactionOperationsBytesPerSec;
    @Config(value={"store.compaction.enable.direct.io"})
    @Default(value="false")
    public final boolean storeCompactionEnableDirectIO;
    @Config(value={"store.compaction.min.buffer.size"})
    @Default(value="10*1024*1024")
    public final int storeCompactionMinBufferSize;
    @Config(value={"store.enable.hard.delete"})
    @Default(value="false")
    public final boolean storeEnableHardDelete;
    @Config(value={"store.segment.size.in.bytes"})
    @Default(value="9223372036854775807")
    public final long storeSegmentSizeInBytes;
    @Config(value={"store.compaction.triggers"})
    @Default(value="")
    public final String[] storeCompactionTriggers;
    @Config(value={"store.compaction.check.frequency.in.hours"})
    @Default(value="7*24")
    public final int storeCompactionCheckFrequencyInHours;
    @Config(value={"store.min.used.capacity.to.trigger.compaction.in.percentage"})
    @Default(value="50")
    public final int storeMinUsedCapacityToTriggerCompactionInPercentage;
    @Config(value={"store.compaction.policy.factory"})
    @Default(value="com.github.ambry.store.CompactAllPolicyFactory")
    public final String storeCompactionPolicyFactory;
    @Config(value={"store.min.log.segment.count.to.reclaim.to.trigger.compaction"})
    @Default(value="1")
    public final int storeMinLogSegmentCountToReclaimToTriggerCompaction;
    @Config(value={"store.stats.bucket.count"})
    @Default(value="0")
    public final int storeStatsBucketCount;
    @Config(value={"store.stats.bucket.span.in.minutes"})
    @Default(value="60")
    public final long storeStatsBucketSpanInMinutes;
    @Config(value={"store.stats.recent.entry.processing.interval.in.minutes"})
    @Default(value="2")
    public final long storeStatsRecentEntryProcessingIntervalInMinutes;
    @Config(value={"store.stats.wait.timeout.in.secs"})
    @Default(value="2*60")
    public final long storeStatsWaitTimeoutInSecs;
    @Config(value={"store.stats.index.entries.per.second"})
    @Default(value="240000")
    public final int storeStatsIndexEntriesPerSecond;
    @Config(value={"store.index.persisted.entry.min.bytes"})
    @Default(value="115")
    public final int storeIndexPersistedEntryMinBytes;
    @Config(value={"store.validate.authorization"})
    @Default(value="false")
    public final boolean storeValidateAuthorization;
    @Config(value={"store.replica.status.delegate.enable"})
    @Default(value="false")
    public final boolean storeReplicaStatusDelegateEnable;
    public static final String storeReplicaStatusDelegateEnableName = "store.replica.status.delegate.enable";
    @Config(value={"store.read.only.enable.size.threshold.percentage"})
    @Default(value="95")
    public final int storeReadOnlyEnableSizeThresholdPercentage;
    public static final String storeReadOnlyEnableSizeThresholdPercentageName = "store.read.only.enable.size.threshold.percentage";
    @Config(value={"store.read.write.enable.size.threshold.percentage.delta"})
    @Default(value="5")
    public final int storeReadWriteEnableSizeThresholdPercentageDelta;
    public static final String storeReadWriteEnableSizeThresholdPercentageDeltaName = "store.read.write.enable.size.threshold.percentage.delta";
    @Config(value={"store.ttl.update.buffer.time.seconds"})
    @Default(value="60 * 60 * 24")
    public final int storeTtlUpdateBufferTimeSeconds;
    public static final String storeTtlUpdateBufferTimeSecondsName = "store.ttl.update.buffer.time.seconds";
    @Config(value={"store.index.mem.state"})
    @Default(value="MMAP_WITHOUT_FORCE_LOAD")
    public final IndexMemState storeIndexMemState;
    public static final String storeIndexMemStateName = "store.index.mem.state";
    @Config(value={"store.io.error.count.to.trigger.shutdown"})
    @Default(value="Integer.MAX_VALUE")
    public final int storeIoErrorCountToTriggerShutdown;
    @Config(value={"store.set.file.permission.enabled"})
    @Default(value="false")
    public final boolean storeSetFilePermissionEnabled;
    @Config(value={"store.data.file.permission"})
    @Default(value="rw-rw----")
    public final Set<PosixFilePermission> storeDataFilePermission;
    @Config(value={"store.operation.file.permission"})
    @Default(value="rw-rw-r--")
    public final Set<PosixFilePermission> storeOperationFilePermission;
    @Config(value={"store.uuid.based.bloom.filter.enabled"})
    @Default(value="false")
    public final boolean storeUuidBasedBloomFilterEnabled;
    @Config(value={"store.index.rebuild.bloom.filter.enabled"})
    @Default(value="false")
    public final boolean storeIndexRebuildBloomFilterEnabled;

    public StoreConfig(VerifiableProperties verifiableProperties) {
        this.storeKeyFactory = verifiableProperties.getString("store.key.factory", "com.github.ambry.commons.BlobIdFactory");
        this.storeDataFlushIntervalSeconds = verifiableProperties.getLong("store.data.flush.interval.seconds", 60L);
        this.storeIndexMaxMemorySizeBytes = verifiableProperties.getInt("store.index.max.memory.size.bytes", 0x1400000);
        this.storeDataFlushDelaySeconds = verifiableProperties.getInt("store.data.flush.delay.seconds", 5);
        this.storeIndexMaxNumberOfInmemElements = verifiableProperties.getInt("store.index.max.number.of.inmem.elements", 10000);
        this.storeIndexBloomMaxFalsePositiveProbability = verifiableProperties.getDoubleInRange("store.index.bloom.max.false.positive.probability", 0.01, 0.0, 1.0);
        this.storeMaxNumberOfEntriesToReturnFromJournal = verifiableProperties.getIntInRange("store.max.number.of.entries.to.return.from.journal", 5000, 1, 10000);
        this.storeDeletedMessageRetentionDays = verifiableProperties.getInt("store.deleted.message.retention.days", 7);
        this.storeHardDeleteOperationsBytesPerSec = verifiableProperties.getIntInRange("store.hard.delete.operations.bytes.per.sec", 102400, 1, Integer.MAX_VALUE);
        this.storeCompactionOperationsBytesPerSec = verifiableProperties.getIntInRange("store.compaction.operations.bytes.per.sec", 0x100000, 1, Integer.MAX_VALUE);
        this.storeCompactionEnableDirectIO = verifiableProperties.getBoolean("store.compaction.enable.direct.io", false);
        this.storeCompactionMinBufferSize = verifiableProperties.getIntInRange("store.compaction.min.buffer.size", 0xA00000, 0, Integer.MAX_VALUE);
        this.storeEnableHardDelete = verifiableProperties.getBoolean("store.enable.hard.delete", false);
        this.storeSegmentSizeInBytes = verifiableProperties.getLongInRange("store.segment.size.in.bytes", Long.MAX_VALUE, 1L, Long.MAX_VALUE);
        this.storeMinUsedCapacityToTriggerCompactionInPercentage = verifiableProperties.getInt("store.min.used.capacity.to.trigger.compaction.in.percentage", 50);
        this.storeCompactionTriggers = verifiableProperties.getString("store.compaction.triggers", "").split(",");
        this.storeCompactionCheckFrequencyInHours = verifiableProperties.getIntInRange("store.compaction.check.frequency.in.hours", 168, 1, 8760);
        this.storeCompactionPolicyFactory = verifiableProperties.getString("store.compaction.policy.factory", "com.github.ambry.store.CompactAllPolicyFactory");
        this.storeMinLogSegmentCountToReclaimToTriggerCompaction = verifiableProperties.getIntInRange("store.min.log.segment.count.to.reclaim.to.trigger.compaction", 1, 1, 1000);
        this.storeStatsBucketCount = verifiableProperties.getIntInRange("store.stats.bucket.count", 0, 0, 10000);
        this.storeStatsBucketSpanInMinutes = verifiableProperties.getLongInRange("store.stats.bucket.span.in.minutes", 60L, 1L, 10000L);
        this.storeStatsRecentEntryProcessingIntervalInMinutes = verifiableProperties.getLongInRange("store.stats.recent.entry.processing.interval.in.minutes", 2L, 1L, 60L);
        this.storeStatsWaitTimeoutInSecs = verifiableProperties.getLongInRange("store.stats.wait.timeout.in.secs", 120L, 0L, 1800L);
        this.storeStatsIndexEntriesPerSecond = verifiableProperties.getIntInRange("store.stats.index.entries.per.second", 240000, 1, Integer.MAX_VALUE);
        this.storeIndexPersistedEntryMinBytes = verifiableProperties.getInt("store.index.persisted.entry.min.bytes", 115);
        this.storeReplicaStatusDelegateEnable = verifiableProperties.getBoolean(storeReplicaStatusDelegateEnableName, false);
        this.storeReadOnlyEnableSizeThresholdPercentage = verifiableProperties.getIntInRange(storeReadOnlyEnableSizeThresholdPercentageName, 95, 0, 100);
        this.storeReadWriteEnableSizeThresholdPercentageDelta = verifiableProperties.getIntInRange(storeReadWriteEnableSizeThresholdPercentageDeltaName, 5, 0, this.storeReadOnlyEnableSizeThresholdPercentage);
        this.storeValidateAuthorization = verifiableProperties.getBoolean("store.validate.authorization", false);
        this.storeTtlUpdateBufferTimeSeconds = verifiableProperties.getIntInRange(storeTtlUpdateBufferTimeSecondsName, 86400, 0, Integer.MAX_VALUE);
        this.storeIndexMemState = IndexMemState.valueOf(verifiableProperties.getString(storeIndexMemStateName, IndexMemState.MMAP_WITHOUT_FORCE_LOAD.name()));
        this.storeIoErrorCountToTriggerShutdown = verifiableProperties.getIntInRange("store.io.error.count.to.trigger.shutdown", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.storeSetFilePermissionEnabled = verifiableProperties.getBoolean("store.set.file.permission.enabled", false);
        String storeDataFilePermissionStr = verifiableProperties.getString("store.data.file.permission", "rw-rw----");
        this.storeDataFilePermission = PosixFilePermissions.fromString(storeDataFilePermissionStr);
        String storeOperationFilePermissionStr = verifiableProperties.getString("store.operation.file.permission", "rw-rw-r--");
        this.storeOperationFilePermission = PosixFilePermissions.fromString(storeOperationFilePermissionStr);
        this.storeUuidBasedBloomFilterEnabled = verifiableProperties.getBoolean("store.uuid.based.bloom.filter.enabled", false);
        this.storeIndexRebuildBloomFilterEnabled = verifiableProperties.getBoolean("store.index.rebuild.bloom.filter.enabled", false);
    }
}

