/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import com.github.ambry.utils.Utils;
import java.util.List;

public class ServerConfig {
    @Config(value={"server.request.handler.num.of.threads"})
    @Default(value="7")
    public final int serverRequestHandlerNumOfThreads;
    @Config(value={"server.scheduler.num.of.threads"})
    @Default(value="10")
    public final int serverSchedulerNumOfthreads;
    @Config(value={"server.stats.publish.local.enabled"})
    @Default(value="false")
    public final boolean serverStatsPublishLocalEnabled;
    @Config(value={"server.stats.publish.health.report.enabled"})
    @Default(value="false")
    public final boolean serverStatsPublishHealthReportEnabled;
    @Config(value={"server.quota.stats.aggregate.interval.in.minutes"})
    @Default(value="60")
    public final long serverQuotaStatsAggregateIntervalInMinutes;
    @Config(value={"server.enable.store.data.prefetch"})
    @Default(value="false")
    public final boolean serverEnableStoreDataPrefetch;
    @Config(value={"server.store.key.converter.factory"})
    @Default(value="com.github.ambry.store.StoreKeyConverterFactoryImpl")
    public final String serverStoreKeyConverterFactory;
    @Config(value={"server.message.transformer"})
    @Default(value="com.github.ambry.messageformat.ValidatingTransformer")
    public final String serverMessageTransformer;
    @Config(value={"server.stats.reports.to.publish"})
    @Default(value="")
    public final List<String> serverStatsReportsToPublish;
    @Config(value={"server.validate.request.based.on.store.state"})
    @Default(value="false")
    public final boolean serverValidateRequestBasedOnStoreState;
    @Config(value={"server.handle.undelete.request.enabled"})
    @Default(value="false")
    public final boolean serverHandleUndeleteRequestEnabled;

    public ServerConfig(VerifiableProperties verifiableProperties) {
        this.serverRequestHandlerNumOfThreads = verifiableProperties.getInt("server.request.handler.num.of.threads", 7);
        this.serverSchedulerNumOfthreads = verifiableProperties.getInt("server.scheduler.num.of.threads", 10);
        this.serverStatsPublishLocalEnabled = verifiableProperties.getBoolean("server.stats.publish.local.enabled", false);
        this.serverStatsPublishHealthReportEnabled = verifiableProperties.getBoolean("server.stats.publish.health.report.enabled", false);
        this.serverQuotaStatsAggregateIntervalInMinutes = verifiableProperties.getLong("server.quota.stats.aggregate.interval.in.minutes", 60L);
        this.serverEnableStoreDataPrefetch = verifiableProperties.getBoolean("server.enable.store.data.prefetch", false);
        this.serverStoreKeyConverterFactory = verifiableProperties.getString("server.store.key.converter.factory", "com.github.ambry.store.StoreKeyConverterFactoryImpl");
        this.serverMessageTransformer = verifiableProperties.getString("server.message.transformer", "com.github.ambry.messageformat.ValidatingTransformer");
        this.serverStatsReportsToPublish = Utils.splitString((String)verifiableProperties.getString("server.stats.reports.to.publish", ""), (String)",");
        this.serverValidateRequestBasedOnStoreState = verifiableProperties.getBoolean("server.validate.request.based.on.store.state", false);
        this.serverHandleUndeleteRequestEnabled = verifiableProperties.getBoolean("server.handle.undelete.request.enabled", false);
    }
}

