/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class SSLConfig {
    @Config(value={"ssl.context.protocol"})
    @Default(value="TLS")
    public final String sslContextProtocol;
    @Config(value={"ssl.context.provider"})
    @Default(value="")
    public final String sslContextProvider;
    @Config(value={"ssl.enabled.protocols"})
    @Default(value="TLSv1.2")
    public final String sslEnabledProtocols;
    @Config(value={"ssl.endpoint.identification.algorithm"})
    @Default(value="")
    public final String sslEndpointIdentificationAlgorithm;
    @Config(value={"ssl.secure.random.algorithm"})
    @Default(value="")
    public final String sslSecureRandomAlgorithm;
    @Config(value={"ssl.client.authentication"})
    @Default(value="required")
    public final String sslClientAuthentication;
    @Config(value={"ssl.keymanager.algorithm"})
    @Default(value="")
    public final String sslKeymanagerAlgorithm;
    @Config(value={"ssl.trustmanager.algorithm"})
    @Default(value="")
    public final String sslTrustmanagerAlgorithm;
    @Config(value={"ssl.keystore.type"})
    @Default(value="JKS")
    public final String sslKeystoreType;
    @Config(value={"ssl.keystore.path"})
    @Default(value="")
    public final String sslKeystorePath;
    @Config(value={"ssl.keystore.password"})
    @Default(value="")
    public final String sslKeystorePassword;
    @Config(value={"ssl.key.password"})
    @Default(value="")
    public final String sslKeyPassword;
    @Config(value={"ssl.truststore.type"})
    @Default(value="JKS")
    public final String sslTruststoreType;
    @Config(value={"ssl.truststore.path"})
    @Default(value="")
    public final String sslTruststorePath;
    @Config(value={"ssl.truststore.password"})
    @Default(value="")
    public final String sslTruststorePassword;
    @Config(value={"ssl.cipher.suites"})
    @Default(value="")
    public final String sslCipherSuites;
    @Config(value={"ssl.factory"})
    @Default(value="com.github.ambry.commons.JdkSslFactory")
    public final String sslFactory;
    @Config(value={"ssl.http2.factory"})
    @Default(value="com.github.ambry.rest.NettySslHttp2Factory")
    public final String sslHttp2Factory;
    @Config(value={"ssl.http2.self.sign"})
    @Default(value="true")
    public final boolean sslHttp2SelfSign;

    public SSLConfig(VerifiableProperties verifiableProperties) {
        this.sslContextProtocol = verifiableProperties.getString("ssl.context.protocol", "TLS");
        this.sslContextProvider = verifiableProperties.getString("ssl.context.provider", "");
        this.sslEnabledProtocols = verifiableProperties.getString("ssl.enabled.protocols", "TLSv1.2");
        this.sslEndpointIdentificationAlgorithm = verifiableProperties.getString("ssl.endpoint.identification.algorithm", "");
        this.sslSecureRandomAlgorithm = verifiableProperties.getString("ssl.secure.random.algorithm", "");
        this.sslClientAuthentication = verifiableProperties.getString("ssl.client.authentication", "required");
        this.sslKeymanagerAlgorithm = verifiableProperties.getString("ssl.keymanager.algorithm", "");
        this.sslTrustmanagerAlgorithm = verifiableProperties.getString("ssl.trustmanager.algorithm", "");
        this.sslKeystoreType = verifiableProperties.getString("ssl.keystore.type", "JKS");
        this.sslKeystorePath = verifiableProperties.getString("ssl.keystore.path", "");
        this.sslKeystorePassword = verifiableProperties.getString("ssl.keystore.password", "");
        this.sslKeyPassword = verifiableProperties.getString("ssl.key.password", "");
        this.sslTruststoreType = verifiableProperties.getString("ssl.truststore.type", "JKS");
        this.sslTruststorePath = verifiableProperties.getString("ssl.truststore.path", "");
        this.sslTruststorePassword = verifiableProperties.getString("ssl.truststore.password", "");
        this.sslCipherSuites = verifiableProperties.getString("ssl.cipher.suites", "");
        this.sslFactory = verifiableProperties.getString("ssl.factory", "com.github.ambry.commons.JdkSslFactory");
        this.sslHttp2Factory = verifiableProperties.getString("ssl.http2.factory", "com.github.ambry.rest.NettySslHttp2Factory");
        this.sslHttp2SelfSign = verifiableProperties.getBoolean("ssl.http2.self.sign", true);
    }
}

