/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;
import com.github.ambry.router.OperationTrackerScope;
import com.github.ambry.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RouterConfig {
    public static final String DEFAULT_KMS_FACTORY = "com.github.ambry.router.SingleKeyManagementServiceFactory";
    public static final String DEFAULT_CRYPTO_SERVICE_FACTORY = "com.github.ambry.router.GCMCryptoServiceFactory";
    public static final double DEFAULT_LATENCY_TOLERANCE_QUANTILE = 0.9;
    public static final long DEFAULT_OPERATION_TRACKER_HISTOGRAM_CACHE_TIMEOUT_MS = 1000L;
    public static final String ROUTER_SCALING_UNIT_COUNT = "router.scaling.unit.count";
    public static final String ROUTER_HOSTNAME = "router.hostname";
    public static final String ROUTER_DATACENTER_NAME = "router.datacenter.name";
    public static final String ROUTER_SCALING_UNIT_MAX_CONNECTIONS_PER_PORT_PLAIN_TEXT = "router.scaling.unit.max.connections.per.port.plain.text";
    public static final String ROUTER_SCALING_UNIT_MAX_CONNECTIONS_PER_PORT_SSL = "router.scaling.unit.max.connections.per.port.ssl";
    public static final String ROUTER_CONNECTIONS_LOCAL_DC_WARM_UP_PERCENTAGE = "router.connections.local.dc.warm.up.percentage";
    public static final String ROUTER_CONNECTIONS_REMOTE_DC_WARM_UP_PERCENTAGE = "router.connections.remote.dc.warm.up.percentage";
    public static final String ROUTER_CONNECTIONS_WARM_UP_TIMEOUT_MS = "router.connections.warm.up.timeout.ms";
    public static final String ROUTER_CONNECTION_CHECKOUT_TIMEOUT_MS = "router.connection.checkout.timeout.ms";
    public static final String ROUTER_REQUEST_TIMEOUT_MS = "router.request.timeout.ms";
    public static final String ROUTER_DROP_REQUEST_ON_TIMEOUT = "router.drop.request.on.timeout";
    public static final String ROUTER_MAX_PUT_CHUNK_SIZE_BYTES = "router.max.put.chunk.size.bytes";
    public static final String ROUTER_PUT_REQUEST_PARALLELISM = "router.put.request.parallelism";
    public static final String ROUTER_PUT_SUCCESS_TARGET = "router.put.success.target";
    public static final String ROUTER_MAX_SLIPPED_PUT_ATTEMPTS = "router.max.slipped.put.attempts";
    public static final String ROUTER_DELETE_REQUEST_PARALLELISM = "router.delete.request.parallelism";
    public static final String ROUTER_DELETE_SUCCESS_TARGET = "router.delete.success.target";
    public static final String ROUTER_GET_REQUEST_PARALLELISM = "router.get.request.parallelism";
    public static final String ROUTER_GET_SUCCESS_TARGET = "router.get.success.target";
    public static final String ROUTER_GET_CROSS_DC_ENABLED = "router.get.cross.dc.enabled";
    public static final String ROUTER_GET_INCLUDE_NON_ORIGINATING_DC_REPLICAS = "router.get.include.non.originating.dc.replicas";
    public static final String ROUTER_GET_REPLICAS_REQUIRED = "router.get.replicas.required";
    public static final String ROUTER_GET_OPERATION_TRACKER_TYPE = "router.get.operation.tracker.type";
    public static final String ROUTER_LATENCY_TOLERANCE_QUANTILE = "router.latency.tolerance.quantile";
    public static final String ROUTER_BLOBID_CURRENT_VERSION = "router.blobid.current.version";
    public static final String ROUTER_METADATA_CONTENT_VERSION = "router.metadata.content.version";
    public static final String ROUTER_KEY_MANAGEMENT_SERVICE_FACTORY = "router.key.management.service.factory";
    public static final String ROUTER_CRYPTO_SERVICE_FACTORY = "router.crypto.service.factory";
    public static final String ROUTER_CRYPTO_JOBS_WORKER_COUNT = "router.crypto.jobs.worker.count";
    public static final String ROUTER_TTL_UPDATE_REQUEST_PARALLELISM = "router.ttl.update.request.parallelism";
    public static final String ROUTER_TTL_UPDATE_SUCCESS_TARGET = "router.ttl.update.success.target";
    public static final String ROUTER_USE_GET_BLOB_OPERATION_FOR_BLOB_INFO = "router.use.get.blob.operation.for.blob.info";
    public static final String ROUTER_OPERATION_TRACKER_CUSTOM_PERCENTILES = "router.operation.tracker.custom.percentiles";
    public static final String ROUTER_OPERATION_TRACKER_METRIC_SCOPE = "router.operation.tracker.metric.scope";
    public static final String ROUTER_OPERATION_TRACKER_RESERVOIR_SIZE = "router.operation.tracker.reservoir.size";
    public static final String ROUTER_OPERATION_TRACKER_RESERVOIR_DECAY_FACTOR = "router.operation.tracker.reservoir.decay.factor";
    public static final String ROUTER_OPERATION_TRACKER_MIN_DATA_POINTS_REQUIRED = "router.operation.tracker.min.data.points.required";
    public static final String ROUTER_OPERATION_TRACKER_TERMINATE_ON_NOT_FOUND_ENABLED = "router.operation.tracker.terminate.on.not.found.enabled";
    public static final String ROUTER_OPERATION_TRACKER_MAX_INFLIGHT_REQUESTS = "router.operation.tracker.max.inflight.requests";
    public static final String ROUTER_OPERATION_TRACKER_EXCLUDE_TIMEOUT_ENABLED = "router.operation.tracker.exclude.timeout.enabled";
    public static final String ROUTER_OPERATION_TRACKER_HISTOGRAM_DUMP_ENABLED = "router.operation.tracker.histogram.dump.enabled";
    public static final String ROUTER_OPERATION_TRACKER_HISTOGRAM_DUMP_PERIOD = "router.operation.tracker.histogram.dump.period";
    public static final String ROUTER_OPERATION_TRACKER_HISTOGRAM_CACHE_TIMEOUT_MS = "router.operation.tracker.histogram.cache.timeout.ms";
    public static final String ROUTER_MAX_IN_MEM_PUT_CHUNKS = "router.max.in.mem.put.chunks";
    public static final String ROUTER_MAX_IN_MEM_GET_CHUNKS = "router.max.in.mem.get.chunks";
    public static final String ROUTER_GET_ELIGIBLE_REPLICAS_BY_STATE_ENABLED = "router.get.eligible.replicas.by.state.enabled";
    public static final String ROUTER_PUT_USE_DYNAMIC_SUCCESS_TARGET = "router.put.use.dynamic.success.target";
    public static final String ROUTER_CLOUD_SUCCESS_TARGET = "router.cloud.success.target";
    public static final String ROUTER_CLOUD_REQUEST_PARALLELISM = "router.cloud.request.parallelism";
    @Config(value={"router.scaling.unit.count"})
    @Default(value="1")
    public final int routerScalingUnitCount;
    @Config(value={"router.hostname"})
    public final String routerHostname;
    @Config(value={"router.datacenter.name"})
    public final String routerDatacenterName;
    @Config(value={"router.scaling.unit.max.connections.per.port.plain.text"})
    @Default(value="5")
    public final int routerScalingUnitMaxConnectionsPerPortPlainText;
    @Config(value={"router.scaling.unit.max.connections.per.port.ssl"})
    @Default(value="2")
    public final int routerScalingUnitMaxConnectionsPerPortSsl;
    @Config(value={"router.connections.local.dc.warm.up.percentage"})
    @Default(value="25")
    public final int routerConnectionsLocalDcWarmUpPercentage;
    @Config(value={"router.connections.remote.dc.warm.up.percentage"})
    @Default(value="0")
    public final int routerConnectionsRemoteDcWarmUpPercentage;
    @Config(value={"router.connections.warm.up.timeout.ms"})
    @Default(value="5000")
    public final int routerConnectionsWarmUpTimeoutMs;
    @Config(value={"router.connection.checkout.timeout.ms"})
    @Default(value="1000")
    public final int routerConnectionCheckoutTimeoutMs;
    @Config(value={"router.request.timeout.ms"})
    @Default(value="2000")
    public final int routerRequestTimeoutMs;
    @Config(value={"router.drop.request.on.timeout"})
    @Default(value="false")
    public final boolean routerDropRequestOnTimeout;
    @Config(value={"router.max.put.chunk.size.bytes"})
    @Default(value="4*1024*1024")
    public final int routerMaxPutChunkSizeBytes;
    @Config(value={"router.put.request.parallelism"})
    @Default(value="3")
    public final int routerPutRequestParallelism;
    @Config(value={"router.put.success.target"})
    @Default(value="2")
    public final int routerPutSuccessTarget;
    @Config(value={"router.max.slipped.put.attempts"})
    @Default(value="1")
    public final int routerMaxSlippedPutAttempts;
    @Config(value={"router.delete.request.parallelism"})
    @Default(value="3")
    public final int routerDeleteRequestParallelism;
    @Config(value={"router.delete.success.target"})
    @Default(value="2")
    public final int routerDeleteSuccessTarget;
    @Config(value={"router.get.request.parallelism"})
    @Default(value="2")
    public final int routerGetRequestParallelism;
    @Config(value={"router.get.success.target"})
    @Default(value="1")
    public final int routerGetSuccessTarget;
    @Config(value={"router.get.cross.dc.enabled"})
    @Default(value="true")
    public final boolean routerGetCrossDcEnabled;
    @Config(value={"router.get.include.non.originating.dc.replicas"})
    @Default(value="true")
    public final boolean routerGetIncludeNonOriginatingDcReplicas;
    @Config(value={"router.get.replicas.required"})
    @Default(value="6")
    public final int routerGetReplicasRequired;
    @Config(value={"router.get.operation.tracker.type"})
    @Default(value="SimpleOperationTracker")
    public final String routerGetOperationTrackerType;
    @Config(value={"router.latency.tolerance.quantile"})
    @Default(value="0.9")
    public final double routerLatencyToleranceQuantile;
    @Config(value={"router.blobid.current.version"})
    @Default(value="5")
    public final short routerBlobidCurrentVersion;
    @Config(value={"router.metadata.content.version"})
    @Default(value="2")
    public final short routerMetadataContentVersion;
    @Config(value={"router.key.management.service.factory"})
    @Default(value="com.github.ambry.router.SingleKeyManagementServiceFactory")
    public final String routerKeyManagementServiceFactory;
    @Config(value={"router.crypto.service.factory"})
    @Default(value="com.github.ambry.router.GCMCryptoServiceFactory")
    public final String routerCryptoServiceFactory;
    @Config(value={"router.crypto.jobs.worker.count"})
    @Default(value="1")
    public final int routerCryptoJobsWorkerCount;
    @Config(value={"router.ttl.update.request.parallelism"})
    @Default(value="3")
    public final int routerTtlUpdateRequestParallelism;
    @Config(value={"router.ttl.update.success.target"})
    @Default(value="2")
    public final int routerTtlUpdateSuccessTarget;
    @Config(value={"router.use.get.blob.operation.for.blob.info"})
    @Default(value="false")
    public final boolean routerUseGetBlobOperationForBlobInfo;
    @Config(value={"router.operation.tracker.custom.percentiles"})
    @Default(value="")
    public final List<Double> routerOperationTrackerCustomPercentiles;
    @Config(value={"router.operation.tracker.metric.scope"})
    @Default(value="Datacenter")
    public final OperationTrackerScope routerOperationTrackerMetricScope;
    @Config(value={"router.operation.tracker.reservoir.size"})
    @Default(value="1028")
    public final int routerOperationTrackerReservoirSize;
    @Config(value={"router.operation.tracker.reservoir.decay.factor"})
    @Default(value="0.015")
    public final double routerOperationTrackerReservoirDecayFactor;
    @Config(value={"router.operation.tracker.min.data.points.required"})
    @Default(value="1000")
    public final long routerOperationTrackerMinDataPointsRequired;
    @Config(value={"router.operation.tracker.terminate.on.not.found.enabled"})
    @Default(value="false")
    public final boolean routerOperationTrackerTerminateOnNotFoundEnabled;
    @Config(value={"router.operation.tracker.max.inflight.requests"})
    @Default(value="2")
    public final int routerOperationTrackerMaxInflightRequests;
    @Config(value={"router.operation.tracker.exclude.timeout.enabled"})
    @Default(value="false")
    public final boolean routerOperationTrackerExcludeTimeoutEnabled;
    @Config(value={"router.operation.tracker.histogram.dump.enabled"})
    @Default(value="false")
    public final boolean routerOperationTrackerHistogramDumpEnabled;
    @Config(value={"router.operation.tracker.histogram.dump.period"})
    @Default(value="600")
    public final long routerOperationTrackerHistogramDumpPeriod;
    @Config(value={"router.operation.tracker.histogram.cache.timeout.ms"})
    @Default(value="1000")
    public final long routerOperationTrackerHistogramCacheTimeoutMs;
    @Config(value={"router.max.in.mem.put.chunks"})
    @Default(value="4")
    public final int routerMaxInMemPutChunks;
    @Config(value={"router.max.in.mem.get.chunks"})
    @Default(value="4")
    public final int routerMaxInMemGetChunks;
    @Config(value={"router.get.eligible.replicas.by.state.enabled"})
    @Default(value="false")
    public final boolean routerGetEligibleReplicasByStateEnabled;
    @Config(value={"router.put.use.dynamic.success.target"})
    @Default(value="false")
    public final boolean routerPutUseDynamicSuccessTarget;
    @Config(value={"router.cloud.success.target"})
    @Default(value="1")
    public final int routerCloudSuccessTarget;
    @Config(value={"router.cloud.request.parallelism"})
    @Default(value="1")
    public final int routerCloudRequestParallelism;

    public RouterConfig(VerifiableProperties verifiableProperties) {
        this.routerScalingUnitCount = verifiableProperties.getIntInRange(ROUTER_SCALING_UNIT_COUNT, 1, 1, Integer.MAX_VALUE);
        this.routerHostname = verifiableProperties.getString(ROUTER_HOSTNAME);
        this.routerDatacenterName = verifiableProperties.getString(ROUTER_DATACENTER_NAME);
        this.routerScalingUnitMaxConnectionsPerPortPlainText = verifiableProperties.getIntInRange(ROUTER_SCALING_UNIT_MAX_CONNECTIONS_PER_PORT_PLAIN_TEXT, 5, 1, 100);
        this.routerScalingUnitMaxConnectionsPerPortSsl = verifiableProperties.getIntInRange(ROUTER_SCALING_UNIT_MAX_CONNECTIONS_PER_PORT_SSL, 2, 1, 100);
        this.routerConnectionsLocalDcWarmUpPercentage = verifiableProperties.getIntInRange(ROUTER_CONNECTIONS_LOCAL_DC_WARM_UP_PERCENTAGE, 25, 0, 100);
        this.routerConnectionsRemoteDcWarmUpPercentage = verifiableProperties.getIntInRange(ROUTER_CONNECTIONS_REMOTE_DC_WARM_UP_PERCENTAGE, 0, 0, 100);
        this.routerConnectionsWarmUpTimeoutMs = verifiableProperties.getIntInRange(ROUTER_CONNECTIONS_WARM_UP_TIMEOUT_MS, 5000, 0, Integer.MAX_VALUE);
        this.routerConnectionCheckoutTimeoutMs = verifiableProperties.getIntInRange(ROUTER_CONNECTION_CHECKOUT_TIMEOUT_MS, 1000, 1, 5000);
        this.routerRequestTimeoutMs = verifiableProperties.getIntInRange(ROUTER_REQUEST_TIMEOUT_MS, 2000, 1, 10000);
        this.routerDropRequestOnTimeout = verifiableProperties.getBoolean(ROUTER_DROP_REQUEST_ON_TIMEOUT, false);
        this.routerMaxPutChunkSizeBytes = verifiableProperties.getIntInRange(ROUTER_MAX_PUT_CHUNK_SIZE_BYTES, 0x400000, 1, Integer.MAX_VALUE);
        this.routerPutRequestParallelism = verifiableProperties.getIntInRange(ROUTER_PUT_REQUEST_PARALLELISM, 3, 1, Integer.MAX_VALUE);
        this.routerPutSuccessTarget = verifiableProperties.getIntInRange(ROUTER_PUT_SUCCESS_TARGET, 2, 1, Integer.MAX_VALUE);
        this.routerMaxSlippedPutAttempts = verifiableProperties.getIntInRange(ROUTER_MAX_SLIPPED_PUT_ATTEMPTS, 1, 0, Integer.MAX_VALUE);
        this.routerDeleteRequestParallelism = verifiableProperties.getIntInRange(ROUTER_DELETE_REQUEST_PARALLELISM, 3, 1, Integer.MAX_VALUE);
        this.routerDeleteSuccessTarget = verifiableProperties.getIntInRange(ROUTER_DELETE_SUCCESS_TARGET, 2, 1, Integer.MAX_VALUE);
        this.routerGetRequestParallelism = verifiableProperties.getIntInRange(ROUTER_GET_REQUEST_PARALLELISM, 2, 1, Integer.MAX_VALUE);
        this.routerGetSuccessTarget = verifiableProperties.getIntInRange(ROUTER_GET_SUCCESS_TARGET, 1, 1, Integer.MAX_VALUE);
        this.routerGetCrossDcEnabled = verifiableProperties.getBoolean(ROUTER_GET_CROSS_DC_ENABLED, true);
        this.routerGetIncludeNonOriginatingDcReplicas = verifiableProperties.getBoolean(ROUTER_GET_INCLUDE_NON_ORIGINATING_DC_REPLICAS, true);
        this.routerGetReplicasRequired = verifiableProperties.getIntInRange(ROUTER_GET_REPLICAS_REQUIRED, 6, 1, Integer.MAX_VALUE);
        this.routerGetOperationTrackerType = verifiableProperties.getString(ROUTER_GET_OPERATION_TRACKER_TYPE, "SimpleOperationTracker");
        this.routerLatencyToleranceQuantile = verifiableProperties.getDoubleInRange(ROUTER_LATENCY_TOLERANCE_QUANTILE, 0.9, 0.0, 1.0);
        this.routerBlobidCurrentVersion = verifiableProperties.getShortFromAllowedValues(ROUTER_BLOBID_CURRENT_VERSION, (short)6, new Short[]{(short)1, (short)2, (short)3, (short)4, (short)5, (short)6});
        this.routerMetadataContentVersion = verifiableProperties.getShortFromAllowedValues(ROUTER_METADATA_CONTENT_VERSION, (short)2, new Short[]{(short)2, (short)3});
        this.routerKeyManagementServiceFactory = verifiableProperties.getString(ROUTER_KEY_MANAGEMENT_SERVICE_FACTORY, DEFAULT_KMS_FACTORY);
        this.routerCryptoServiceFactory = verifiableProperties.getString(ROUTER_CRYPTO_SERVICE_FACTORY, DEFAULT_CRYPTO_SERVICE_FACTORY);
        this.routerCryptoJobsWorkerCount = verifiableProperties.getIntInRange(ROUTER_CRYPTO_JOBS_WORKER_COUNT, 1, 1, Integer.MAX_VALUE);
        this.routerTtlUpdateRequestParallelism = verifiableProperties.getIntInRange(ROUTER_TTL_UPDATE_REQUEST_PARALLELISM, 3, 1, Integer.MAX_VALUE);
        this.routerTtlUpdateSuccessTarget = verifiableProperties.getIntInRange(ROUTER_TTL_UPDATE_SUCCESS_TARGET, 2, 1, Integer.MAX_VALUE);
        this.routerUseGetBlobOperationForBlobInfo = verifiableProperties.getBoolean(ROUTER_USE_GET_BLOB_OPERATION_FOR_BLOB_INFO, false);
        ArrayList customPercentiles = Utils.splitString((String)verifiableProperties.getString(ROUTER_OPERATION_TRACKER_CUSTOM_PERCENTILES, ""), (String)",");
        this.routerOperationTrackerCustomPercentiles = Collections.unmodifiableList(customPercentiles.stream().map(Double::valueOf).collect(Collectors.toList()));
        String scopeStr = verifiableProperties.getString(ROUTER_OPERATION_TRACKER_METRIC_SCOPE, "Datacenter");
        this.routerOperationTrackerMetricScope = OperationTrackerScope.valueOf(scopeStr);
        this.routerOperationTrackerReservoirSize = verifiableProperties.getIntInRange(ROUTER_OPERATION_TRACKER_RESERVOIR_SIZE, 1028, 0, Integer.MAX_VALUE);
        this.routerOperationTrackerReservoirDecayFactor = verifiableProperties.getDouble(ROUTER_OPERATION_TRACKER_RESERVOIR_DECAY_FACTOR, 0.015);
        this.routerOperationTrackerMinDataPointsRequired = verifiableProperties.getLong(ROUTER_OPERATION_TRACKER_MIN_DATA_POINTS_REQUIRED, 1000L);
        this.routerOperationTrackerMaxInflightRequests = verifiableProperties.getIntInRange(ROUTER_OPERATION_TRACKER_MAX_INFLIGHT_REQUESTS, 2, 1, Integer.MAX_VALUE);
        this.routerOperationTrackerExcludeTimeoutEnabled = verifiableProperties.getBoolean(ROUTER_OPERATION_TRACKER_EXCLUDE_TIMEOUT_ENABLED, false);
        this.routerOperationTrackerHistogramDumpEnabled = verifiableProperties.getBoolean(ROUTER_OPERATION_TRACKER_HISTOGRAM_DUMP_ENABLED, false);
        this.routerOperationTrackerHistogramDumpPeriod = verifiableProperties.getLongInRange(ROUTER_OPERATION_TRACKER_HISTOGRAM_DUMP_PERIOD, 600L, 1L, Long.MAX_VALUE);
        this.routerOperationTrackerHistogramCacheTimeoutMs = verifiableProperties.getLong(ROUTER_OPERATION_TRACKER_HISTOGRAM_CACHE_TIMEOUT_MS, 1000L);
        if (this.routerGetRequestParallelism > this.routerOperationTrackerMaxInflightRequests) {
            throw new IllegalArgumentException("Operation tracker parallelism is larger than operation tracker max inflight number");
        }
        this.routerOperationTrackerTerminateOnNotFoundEnabled = verifiableProperties.getBoolean(ROUTER_OPERATION_TRACKER_TERMINATE_ON_NOT_FOUND_ENABLED, false);
        this.routerMaxInMemPutChunks = verifiableProperties.getIntInRange(ROUTER_MAX_IN_MEM_PUT_CHUNKS, 4, 1, Integer.MAX_VALUE / this.routerMaxPutChunkSizeBytes);
        this.routerMaxInMemGetChunks = verifiableProperties.getIntInRange(ROUTER_MAX_IN_MEM_GET_CHUNKS, 4, 1, Integer.MAX_VALUE / this.routerMaxPutChunkSizeBytes);
        this.routerGetEligibleReplicasByStateEnabled = verifiableProperties.getBoolean(ROUTER_GET_ELIGIBLE_REPLICAS_BY_STATE_ENABLED, false);
        this.routerPutUseDynamicSuccessTarget = verifiableProperties.getBoolean(ROUTER_PUT_USE_DYNAMIC_SUCCESS_TARGET, false);
        this.routerCloudSuccessTarget = verifiableProperties.getIntInRange(ROUTER_CLOUD_SUCCESS_TARGET, 1, 1, Integer.MAX_VALUE);
        this.routerCloudRequestParallelism = verifiableProperties.getIntInRange(ROUTER_CLOUD_REQUEST_PARALLELISM, 1, 1, Integer.MAX_VALUE);
    }
}

