/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class HelixAccountServiceConfig {
    public static final String HELIX_ACCOUNT_SERVICE_PREFIX = "helix.account.service.";
    public static final String UPDATER_POLLING_INTERVAL_MS_KEY = "helix.account.service.updater.polling.interval.ms";
    public static final String UPDATER_SHUT_DOWN_TIMEOUT_MS_KEY = "helix.account.service.updater.shut.down.timeout.ms";
    public static final String BACKUP_DIRECTORY_KEY = "helix.account.service.backup.dir";
    public static final String MAX_BACKUP_FILE_COUNT = "helix.account.service.max.backup.file.count";
    public static final String ZK_CLIENT_CONNECT_STRING_KEY = "helix.account.service.zk.client.connect.string";
    public static final String USE_NEW_ZNODE_PATH = "helix.account.service.use.new.znode.path";
    public static final String UPDATE_DISABLED = "helix.account.service.update.disabled";
    public static final String BACKFILL_ACCOUNTS_TO_NEW_ZNODE = "helix.account.service.backfill.accounts.to.new.znode";
    public static final String ENABLE_SERVE_FROM_BACKUP = "helix.account.service.enable.serve.from.backup";
    public static final String TOTAL_NUMBER_OF_VERSION_TO_KEEP = "helix.account.service.total.number.of.version.to.keep";
    @Config(value={"helix.account.service.zk.client.connect.string"})
    public final String zkClientConnectString;
    @Config(value={"helix.account.service.updater.polling.interval.ms"})
    @Default(value="60 * 60 * 1000")
    public final int updaterPollingIntervalMs;
    @Config(value={"helix.account.service.updater.shut.down.timeout.ms"})
    @Default(value="60 * 1000")
    public final int updaterShutDownTimeoutMs;
    @Config(value={"helix.account.service.backup.dir"})
    @Default(value="")
    public final String backupDir;
    @Config(value={"helix.account.service.max.backup.file.count"})
    @Default(value="100")
    public final int maxBackupFileCount;
    @Config(value={"helix.account.service.use.new.znode.path"})
    @Default(value="false")
    public final boolean useNewZNodePath;
    @Config(value={"helix.account.service.update.disabled"})
    @Default(value="false")
    public final boolean updateDisabled;
    @Config(value={"helix.account.service.backfill.accounts.to.new.znode"})
    @Default(value="false")
    public final boolean backFillAccountsToNewZNode;
    @Config(value={"helix.account.service.enable.serve.from.backup"})
    @Default(value="false")
    public final boolean enableServeFromBackup;
    @Config(value={"helix.account.service.total.number.of.version.to.keep"})
    @Default(value="100")
    public final int totalNumberOfVersionToKeep;

    public HelixAccountServiceConfig(VerifiableProperties verifiableProperties) {
        this.zkClientConnectString = verifiableProperties.getString(ZK_CLIENT_CONNECT_STRING_KEY);
        this.updaterPollingIntervalMs = verifiableProperties.getIntInRange(UPDATER_POLLING_INTERVAL_MS_KEY, 3600000, 0, Integer.MAX_VALUE);
        this.updaterShutDownTimeoutMs = verifiableProperties.getIntInRange(UPDATER_SHUT_DOWN_TIMEOUT_MS_KEY, 60000, 1, Integer.MAX_VALUE);
        this.backupDir = verifiableProperties.getString(BACKUP_DIRECTORY_KEY, "");
        this.maxBackupFileCount = verifiableProperties.getIntInRange(MAX_BACKUP_FILE_COUNT, 100, 1, Integer.MAX_VALUE);
        this.useNewZNodePath = verifiableProperties.getBoolean(USE_NEW_ZNODE_PATH, false);
        this.updateDisabled = verifiableProperties.getBoolean(UPDATE_DISABLED, false);
        this.backFillAccountsToNewZNode = verifiableProperties.getBoolean(BACKFILL_ACCOUNTS_TO_NEW_ZNODE, false);
        if (this.backFillAccountsToNewZNode && this.useNewZNodePath) {
            throw new IllegalStateException("useNewZNodePath and backFillAccountsToNewZNode can't be true at the same time.");
        }
        this.enableServeFromBackup = verifiableProperties.getBoolean(ENABLE_SERVE_FROM_BACKUP, false);
        this.totalNumberOfVersionToKeep = verifiableProperties.getIntInRange(TOTAL_NUMBER_OF_VERSION_TO_KEEP, 100, 1, Integer.MAX_VALUE);
    }
}

