/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class DiskManagerConfig {
    @Config(value={"disk.manager.reserve.file.dir.name"})
    @Default(value="reserve-pool")
    public final String diskManagerReserveFileDirName;
    @Config(value={"disk.manager.required.swap.segments.per.size"})
    @Default(value="1")
    public final int diskManagerRequiredSwapSegmentsPerSize;
    @Config(value={"disk.manager.enable.segment.pooling"})
    @Default(value="false")
    public final boolean diskManagerEnableSegmentPooling;

    public DiskManagerConfig(VerifiableProperties verifiableProperties) {
        this.diskManagerReserveFileDirName = verifiableProperties.getString("disk.manager.reserve.file.dir.name", "reserve-pool");
        this.diskManagerRequiredSwapSegmentsPerSize = verifiableProperties.getIntInRange("disk.manager.required.swap.segments.per.size", 1, 0, 1000);
        this.diskManagerEnableSegmentPooling = verifiableProperties.getBoolean("disk.manager.enable.segment.pooling", false);
    }
}

