/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.config;

import com.github.ambry.config.Config;
import com.github.ambry.config.Default;
import com.github.ambry.config.VerifiableProperties;

public class CloudConfig {
    public static final String CLOUD_IS_VCR = "cloud.is.vcr";
    public static final String VIRTUAL_REPLICATOR_CLUSTER_FACTORY_CLASS = "virtual.replicator.cluster.factory.class";
    public static final String CLOUD_DESTINATION_FACTORY_CLASS = "cloud.destination.factory.class";
    public static final String VCR_CLUSTER_ZK_CONNECT_STRING = "vcr.cluster.zk.connect.string";
    public static final String VCR_CLUSTER_NAME = "vcr.cluster.name";
    public static final String VCR_SSL_PORT = "vcr.ssl.port";
    public static final String VCR_HTTP2_PORT = "vcr.http2.port";
    public static final String VCR_REQUIRE_ENCRYPTION = "vcr.require.encryption";
    public static final String VCR_KMS_FACTORY = "vcr.key.management.service.factory";
    public static final String VCR_CRYPTO_SERVICE_FACTORY = "vcr.crypto.service.factory";
    public static final String VCR_MIN_TTL_DAYS = "vcr.min.ttl.days";
    public static final String CLOUD_DELETED_BLOB_RETENTION_DAYS = "cloud.deleted.blob.retention.days";
    public static final String CLOUD_BLOB_COMPACTION_ENABLED = "cloud.blob.compaction.enabled";
    public static final String CLOUD_BLOB_COMPACTION_INTERVAL_HOURS = "cloud.blob.compaction.interval.hours";
    public static final String CLOUD_BLOB_COMPACTION_QUERY_LIMIT = "cloud.blob.compaction.query.limit";
    public static final String CLOUD_RECENT_BLOB_CACHE_LIMIT = "cloud.recent.blob.cache.limit";
    public static final String CLOUD_MAX_ATTEMPTS = "cloud.max.attempts";
    public static final String CLOUD_DEFAULT_RETRY_DELAY = "cloud.default.retry.delay";
    public static final String CLOUD_REQUEST_TIMEOUT = "cloud.request.timeout";
    public static final String CLOUD_UPLOAD_REQUEST_TIMEOUT = "cloud.upload.request.timeout";
    public static final String CLOUD_QUERY_REQUEST_TIMEOUT = "cloud.query.request.timeout";
    public static final String CLOUD_BATCH_REQUEST_TIMEOUT = "cloud.batch.request.timeout";
    public static final String VCR_ASSIGNED_PARTITIONS = "vcr.assigned.partitions";
    public static final String VCR_PROXY_HOST = "vcr.proxy.host";
    public static final String VCR_PROXY_PORT = "vcr.proxy.port";
    public static final String VCR_CLUSTER_SPECTATOR_FACTORY_CLASS = "vcr.cluster.spectator.factory.class";
    public static final String DEFAULT_VIRTUAL_REPLICATOR_CLUSTER_FACTORY_CLASS = "com.github.ambry.cloud.StaticVcrClusterFactory";
    public static final String DEFAULT_CLOUD_DESTINATION_FACTORY_CLASS = "com.github.ambry.cloud.azure.AzureCloudDestinationFactory";
    public static final String KMS_SERVICE_KEY_CONTEXT = "kms.service.key.context";
    public static final String DEFAULT_KMS_SERVICE_KEY_CONTEXT = "default-backup";
    public static final String CLOUD_BLOB_CRYPTO_AGENT_FACTORY_CLASS = "cloud.blob.crypto.agent.factory.class";
    public static final String DEFAULT_CLOUD_BLOB_CRYPTO_AGENT_FACTORY_CLASS = "com.github.ambry.cloud.CloudBlobCryptoAgentFactoryImpl";
    public static final String DEFAULT_VCR_CLUSTER_ZK_CONNECT_STRING = "localhost:2181";
    public static final String DEFAULT_VCR_CLUSTER_NAME = "VCRCluster";
    public static final int DEFAULT_MIN_TTL_DAYS = 14;
    public static final int DEFAULT_RETENTION_DAYS = 7;
    public static final int DEFAULT_COMPACTION_QUERY_LIMIT = 100;
    public static final int DEFAULT_RECENT_BLOB_CACHE_LIMIT = 10000;
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_DELAY_VALUE = 50;
    public static final int DEFAULT_CLOUD_REQUEST_TIMEOUT = 500;
    public static final int DEFAULT_UPLOAD_TIMEOUT = 5000;
    public static final int DEFAULT_QUERY_TIMEOUT = 60000;
    public static final int DEFAULT_BATCH_TIMEOUT = 60000;
    public static final int DEFAULT_VCR_PROXY_PORT = 3128;
    public static final String DEFAULT_VCR_CLUSTER_SPECTATOR_FACTORY_CLASS = "com.github.ambry.clustermap.HelixClusterSpectatorFactory";
    @Config(value={"cloud.is.vcr"})
    @Default(value="false")
    public final boolean cloudIsVcr;
    @Config(value={"virtual.replicator.cluster.factory.class"})
    @Default(value="com.github.ambry.cloud.StaticVcrClusterFactory")
    public final String virtualReplicatorClusterFactoryClass;
    @Config(value={"cloud.destination.factory.class"})
    @Default(value="com.github.ambry.cloud.azure.AzureCloudDestinationFactory")
    public final String cloudDestinationFactoryClass;
    @Config(value={"vcr.cluster.zk.connect.string"})
    @Default(value="localhost:2181")
    public final String vcrClusterZkConnectString;
    @Config(value={"vcr.cluster.name"})
    @Default(value="VCRCluster")
    public final String vcrClusterName;
    @Config(value={"vcr.ssl.port"})
    @Default(value="null")
    public final Integer vcrSslPort;
    @Config(value={"vcr.http2.port"})
    @Default(value="null")
    public final Integer vcrHttp2Port;
    @Config(value={"vcr.require.encryption"})
    @Default(value="false")
    public final boolean vcrRequireEncryption;
    @Config(value={"kms.service.key.context"})
    @Default(value="default-backup")
    public final String kmsServiceKeyContext;
    @Config(value={"cloud.blob.crypto.agent.factory.class"})
    @Default(value="com.github.ambry.cloud.CloudBlobCryptoAgentFactoryImpl")
    public final String cloudBlobCryptoAgentFactoryClass;
    @Config(value={"vcr.key.management.service.factory"})
    @Default(value="com.github.ambry.router.SingleKeyManagementServiceFactory")
    public final String vcrKeyManagementServiceFactory;
    @Config(value={"vcr.crypto.service.factory"})
    @Default(value="com.github.ambry.router.GCMCryptoServiceFactory")
    public final String vcrCryptoServiceFactory;
    @Config(value={"vcr.min.ttl.days"})
    @Default(value="14")
    public final int vcrMinTtlDays;
    @Config(value={"cloud.deleted.blob.retention.days"})
    @Default(value="7")
    public final int cloudDeletedBlobRetentionDays;
    @Config(value={"cloud.blob.compaction.enabled"})
    @Default(value="true")
    public final boolean cloudBlobCompactionEnabled;
    @Config(value={"cloud.blob.compaction.query.limit"})
    @Default(value="100")
    public final int cloudBlobCompactionQueryLimit;
    @Config(value={"cloud.blob.compaction.interval.hours"})
    @Default(value="24")
    public final int cloudBlobCompactionIntervalHours;
    @Config(value={"cloud.recent.blob.cache.limit"})
    @Default(value="10000")
    public final int recentBlobCacheLimit;
    @Config(value={"vcr.assigned.partitions"})
    @Default(value="null")
    public final String vcrAssignedPartitions;
    @Config(value={"vcr.proxy.host"})
    @Default(value="null")
    public final String vcrProxyHost;
    @Config(value={"vcr.proxy.port"})
    @Default(value="3128")
    public final int vcrProxyPort;
    @Config(value={"cloud.max.attempts"})
    public final int cloudMaxAttempts;
    @Config(value={"cloud.default.retry.delay"})
    public final int cloudDefaultRetryDelay;
    @Config(value={"cloud.request.timeout"})
    public final int cloudRequestTimeout;
    @Config(value={"cloud.upload.request.timeout"})
    public final int cloudUploadRequestTimeout;
    @Config(value={"cloud.query.request.timeout"})
    public final int cloudQueryRequestTimeout;
    @Config(value={"cloud.batch.request.timeout"})
    public final int cloudBatchRequestTimeout;
    @Config(value={"vcr.cluster.spectator.factory.class"})
    @Default(value="com.github.ambry.clustermap.HelixClusterSpectatorFactory")
    public final String vcrClusterSpectatorFactoryClass;

    public CloudConfig(VerifiableProperties verifiableProperties) {
        this.cloudIsVcr = verifiableProperties.getBoolean(CLOUD_IS_VCR, false);
        this.virtualReplicatorClusterFactoryClass = verifiableProperties.getString(VIRTUAL_REPLICATOR_CLUSTER_FACTORY_CLASS, DEFAULT_VIRTUAL_REPLICATOR_CLUSTER_FACTORY_CLASS);
        this.cloudDestinationFactoryClass = verifiableProperties.getString(CLOUD_DESTINATION_FACTORY_CLASS, DEFAULT_CLOUD_DESTINATION_FACTORY_CLASS);
        this.vcrAssignedPartitions = verifiableProperties.getString(VCR_ASSIGNED_PARTITIONS, null);
        this.vcrClusterZkConnectString = verifiableProperties.getString(VCR_CLUSTER_ZK_CONNECT_STRING, DEFAULT_VCR_CLUSTER_ZK_CONNECT_STRING);
        this.vcrClusterName = verifiableProperties.getString(VCR_CLUSTER_NAME, DEFAULT_VCR_CLUSTER_NAME);
        this.vcrSslPort = verifiableProperties.getInteger(VCR_SSL_PORT, null);
        this.vcrHttp2Port = verifiableProperties.getInteger(VCR_HTTP2_PORT, null);
        this.vcrRequireEncryption = verifiableProperties.getBoolean(VCR_REQUIRE_ENCRYPTION, false);
        this.vcrKeyManagementServiceFactory = verifiableProperties.getString(VCR_KMS_FACTORY, "com.github.ambry.router.SingleKeyManagementServiceFactory");
        this.vcrCryptoServiceFactory = verifiableProperties.getString(VCR_CRYPTO_SERVICE_FACTORY, "com.github.ambry.router.GCMCryptoServiceFactory");
        this.kmsServiceKeyContext = verifiableProperties.getString(KMS_SERVICE_KEY_CONTEXT, DEFAULT_KMS_SERVICE_KEY_CONTEXT);
        this.cloudBlobCryptoAgentFactoryClass = verifiableProperties.getString(CLOUD_BLOB_CRYPTO_AGENT_FACTORY_CLASS, DEFAULT_CLOUD_BLOB_CRYPTO_AGENT_FACTORY_CLASS);
        this.vcrMinTtlDays = verifiableProperties.getInt(VCR_MIN_TTL_DAYS, 14);
        this.cloudDeletedBlobRetentionDays = verifiableProperties.getInt(CLOUD_DELETED_BLOB_RETENTION_DAYS, 7);
        this.cloudBlobCompactionEnabled = verifiableProperties.getBoolean(CLOUD_BLOB_COMPACTION_ENABLED, true);
        this.cloudBlobCompactionIntervalHours = verifiableProperties.getInt(CLOUD_BLOB_COMPACTION_INTERVAL_HOURS, 24);
        this.cloudBlobCompactionQueryLimit = verifiableProperties.getInt(CLOUD_BLOB_COMPACTION_QUERY_LIMIT, 100);
        this.recentBlobCacheLimit = verifiableProperties.getInt(CLOUD_RECENT_BLOB_CACHE_LIMIT, 10000);
        this.cloudMaxAttempts = verifiableProperties.getInt(CLOUD_MAX_ATTEMPTS, 3);
        this.cloudDefaultRetryDelay = verifiableProperties.getInt(CLOUD_DEFAULT_RETRY_DELAY, 50);
        this.cloudRequestTimeout = verifiableProperties.getInt(CLOUD_REQUEST_TIMEOUT, 500);
        this.cloudUploadRequestTimeout = verifiableProperties.getInt(CLOUD_UPLOAD_REQUEST_TIMEOUT, 5000);
        this.cloudQueryRequestTimeout = verifiableProperties.getInt(CLOUD_QUERY_REQUEST_TIMEOUT, 60000);
        this.cloudBatchRequestTimeout = verifiableProperties.getInt(CLOUD_BATCH_REQUEST_TIMEOUT, 60000);
        this.vcrProxyHost = verifiableProperties.getString(VCR_PROXY_HOST, null);
        this.vcrProxyPort = verifiableProperties.getInt(VCR_PROXY_PORT, 3128);
        this.vcrClusterSpectatorFactoryClass = verifiableProperties.getString(VCR_CLUSTER_SPECTATOR_FACTORY_CLASS, DEFAULT_VCR_CLUSTER_SPECTATOR_FACTORY_CLASS);
    }
}

