/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.commons;

import java.util.Objects;

public class Criteria {
    private final long threshold;
    private final BoundType boundType;

    public Criteria(long threshold, BoundType boundType) {
        this.threshold = threshold;
        this.boundType = boundType;
    }

    boolean meetRequirement(Long value) throws NullPointerException {
        Objects.requireNonNull(value, "Input value is empty which cannot be applied to threshold check.");
        return this.boundType == BoundType.UpperBound ? value <= this.threshold : value >= this.threshold;
    }

    public long getThresholdValue() {
        return this.threshold;
    }

    public static enum BoundType {
        UpperBound,
        LowerBound;

    }
}

