/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.clustermap;

import com.github.ambry.clustermap.HardwareState;
import com.github.ambry.clustermap.Resource;
import com.github.ambry.network.Port;

public interface DataNodeId
extends Resource,
Comparable<DataNodeId> {
    public String getHostname();

    public int getPort();

    public int getSSLPort();

    public boolean hasSSLPort();

    public int getHttp2Port();

    public boolean hasHttp2Port();

    public Port getPortToConnectTo();

    public HardwareState getState();

    public String getDatacenterName();

    public String getRackId();

    public long getXid();

    @Override
    default public int compareTo(DataNodeId o) {
        if (o == null) {
            throw new NullPointerException("input argument null");
        }
        int compare = Integer.compare(this.getPort(), o.getPort());
        if (compare == 0) {
            compare = this.getHostname().compareTo(o.getHostname());
        }
        return compare;
    }
}

