/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.account;

import com.github.ambry.account.Container;
import java.util.Set;

public class ContainerBuilder {
    private short id;
    private String name;
    private Container.ContainerStatus status;
    private String description;
    private short parentAccountId;
    private boolean encrypted = false;
    private boolean previouslyEncrypted = false;
    private boolean cacheable = true;
    private boolean mediaScanDisabled = false;
    private String replicationPolicy = null;
    private boolean ttlRequired = true;
    private boolean securePathRequired = false;
    private Set<String> contentTypeWhitelistForFilenamesOnDownload = Container.CONTENT_TYPE_WHITELIST_FOR_FILENAMES_ON_DOWNLOAD_DEFAULT_VALUE;
    private boolean backupEnabled = false;

    public ContainerBuilder(Container origin) {
        if (origin == null) {
            throw new IllegalArgumentException("origin cannot be null.");
        }
        this.id = origin.getId();
        this.name = origin.getName();
        this.status = origin.getStatus();
        this.description = origin.getDescription();
        this.encrypted = origin.isEncrypted();
        this.previouslyEncrypted = origin.wasPreviouslyEncrypted();
        this.cacheable = origin.isCacheable();
        this.mediaScanDisabled = origin.isMediaScanDisabled();
        this.replicationPolicy = origin.getReplicationPolicy();
        this.ttlRequired = origin.isTtlRequired();
        this.parentAccountId = origin.getParentAccountId();
        this.securePathRequired = origin.isSecurePathRequired();
        this.contentTypeWhitelistForFilenamesOnDownload = origin.getContentTypeWhitelistForFilenamesOnDownload();
        this.backupEnabled = origin.isBackupEnabled();
    }

    public ContainerBuilder(short id, String name, Container.ContainerStatus status, String description, short parentAccountId) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.description = description;
        this.parentAccountId = parentAccountId;
    }

    public ContainerBuilder setId(short id) {
        this.id = id;
        return this;
    }

    public ContainerBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ContainerBuilder setStatus(Container.ContainerStatus status) {
        this.status = status;
        return this;
    }

    public ContainerBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ContainerBuilder setParentAccountId(short parentAccountId) {
        this.parentAccountId = parentAccountId;
        return this;
    }

    public ContainerBuilder setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public ContainerBuilder setPreviouslyEncrypted(boolean previouslyEncrypted) {
        this.previouslyEncrypted = previouslyEncrypted;
        return this;
    }

    public ContainerBuilder setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public ContainerBuilder setBackupEnabled(boolean backupEnabled) {
        this.backupEnabled = backupEnabled;
        return this;
    }

    public ContainerBuilder setMediaScanDisabled(boolean mediaScanDisabled) {
        this.mediaScanDisabled = mediaScanDisabled;
        return this;
    }

    public ContainerBuilder setTtlRequired(boolean ttlRequired) {
        this.ttlRequired = ttlRequired;
        return this;
    }

    public ContainerBuilder setSecurePathRequired(boolean securePathRequired) {
        this.securePathRequired = securePathRequired;
        return this;
    }

    public ContainerBuilder setReplicationPolicy(String replicationPolicy) {
        this.replicationPolicy = replicationPolicy;
        return this;
    }

    public ContainerBuilder setContentTypeWhitelistForFilenamesOnDownload(Set<String> contentTypeWhitelistForFilenamesOnDownload) {
        this.contentTypeWhitelistForFilenamesOnDownload = contentTypeWhitelistForFilenamesOnDownload;
        return this;
    }

    public Container build() {
        return new Container(this.id, this.name, this.status, this.description, this.encrypted, this.previouslyEncrypted || this.encrypted, this.cacheable, this.mediaScanDisabled, this.replicationPolicy, this.ttlRequired, this.securePathRequired, this.contentTypeWhitelistForFilenamesOnDownload, this.backupEnabled, this.parentAccountId);
    }
}

