/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline.painter.point;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import com.alorma.timeline.R;
import com.alorma.timeline.painter.Painter;
import com.alorma.timeline.painter.point.CirclePointStylePainter;
import com.alorma.timeline.painter.point.PointStylePainter;
import com.alorma.timeline.painter.point.SquarePointStylePainter;
import com.alorma.timeline.property.PointStyle;
import com.alorma.timeline.property.Property;
import com.alorma.timeline.property.TimelinePosition;
import com.alorma.timeline.property.TimelinePositionOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010\"\u001a\u00020\u0016\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/alorma/timeline/painter/point/PointPainter;", "Lcom/alorma/timeline/painter/Painter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "circlePainter", "Lcom/alorma/timeline/painter/point/PointStylePainter;", "currentPainter", "fillColor", "", "fillSize", "", "horizontalPosition", "Lcom/alorma/timeline/property/TimelinePositionOption;", "squarePainter", "strokeColor", "strokeSize", "validHorizontalPositions", "", "validVerticalPositions", "verticalPosition", "draw", "", "canvas", "Landroid/graphics/Canvas;", "rect", "Landroid/graphics/Rect;", "getPointStylePainter", "style", "initProperties", "typedArray", "Landroid/content/res/TypedArray;", "loadColors", "loadSizes", "updateProperty", "T", "property", "Lcom/alorma/timeline/property/Property;", "Companion", "timeline_release"})
public final class PointPainter
implements Painter {
    private final PointStylePainter circlePainter;
    private final PointStylePainter squarePainter;
    private PointStylePainter currentPainter;
    private int strokeColor;
    private int fillColor;
    private float fillSize;
    private float strokeSize;
    private List<? extends TimelinePositionOption> validVerticalPositions;
    private List<? extends TimelinePositionOption> validHorizontalPositions;
    private TimelinePositionOption verticalPosition;
    private TimelinePositionOption horizontalPosition;
    public static final int CIRCLE = -1;
    public static final int SQUARE = 0;
    public static final Companion Companion = new Companion(null);

    @Override
    public void initProperties(@NotNull TypedArray typedArray) {
        Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
        this.circlePainter.initProperties(typedArray);
        this.squarePainter.initProperties(typedArray);
        int style = typedArray.getInt(R.styleable.TimelineView_timeline_pointStyle, -1);
        this.currentPainter = this.getPointStylePainter(style);
        this.loadColors(typedArray);
        this.loadSizes(typedArray);
    }

    private final void loadColors(TypedArray typedArray) {
        this.strokeColor = typedArray.getColor(R.styleable.TimelineView_timeline_pointBorderColor, this.strokeColor);
        this.fillColor = typedArray.getColor(R.styleable.TimelineView_timeline_pointFillColor, this.fillColor);
        this.circlePainter.initColors(this.strokeColor, this.fillColor);
        this.squarePainter.initColors(this.strokeColor, this.fillColor);
    }

    private final void loadSizes(TypedArray typedArray) {
        this.fillSize = typedArray.getDimension(R.styleable.TimelineView_timeline_pointFillSize, this.fillSize);
        this.strokeSize = typedArray.getDimension(R.styleable.TimelineView_timeline_pointStrokeSize, this.strokeSize);
        this.circlePainter.initSizes(this.strokeSize, this.fillSize);
        this.squarePainter.initSizes(this.strokeSize, this.fillSize);
    }

    private final PointStylePainter getPointStylePainter(int style) {
        PointStylePainter pointStylePainter;
        switch (style) {
            case 0: {
                pointStylePainter = this.squarePainter;
                break;
            }
            default: {
                pointStylePainter = this.circlePainter;
            }
        }
        return pointStylePainter;
    }

    @Override
    public <T> void updateProperty(@NotNull Property<T> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Property<T> property2 = property;
        if (property2 instanceof TimelinePosition) {
            TimelinePositionOption timelinePositionOption;
            Object var10_10;
            PointPainter pointPainter;
            block10: {
                Object v2;
                TimelinePositionOption timelinePositionOption2;
                TimelinePositionOption it;
                Iterable $receiver$iv;
                block9: {
                    Object v0;
                    Iterable iterable = (Iterable)((TimelinePosition)property).getValue();
                    pointPainter = this;
                    for (Object element$iv : $receiver$iv) {
                        it = (TimelinePositionOption)element$iv;
                        boolean bl = false;
                        if (!this.validVerticalPositions.contains(it)) continue;
                        v0 = element$iv;
                        break block9;
                    }
                    v0 = var10_10 = null;
                }
                if ((timelinePositionOption2 = (TimelinePositionOption)var10_10) == null) {
                    timelinePositionOption2 = pointPainter.verticalPosition = this.verticalPosition;
                }
                if (this.verticalPosition instanceof TimelinePositionOption.POSITION_CENTER) {
                    this.verticalPosition = TimelinePositionOption.POSITION_CENTER_VERTICAL.INSTANCE;
                }
                $receiver$iv = (Iterable)((TimelinePosition)property).getValue();
                pointPainter = this;
                for (Object element$iv : $receiver$iv) {
                    it = (TimelinePositionOption)element$iv;
                    boolean bl = false;
                    if (!this.validHorizontalPositions.contains(it)) continue;
                    v2 = element$iv;
                    break block10;
                }
                v2 = var10_10 = null;
            }
            if ((timelinePositionOption = (TimelinePositionOption)var10_10) == null) {
                timelinePositionOption = pointPainter.horizontalPosition = this.horizontalPosition;
            }
            if (this.horizontalPosition instanceof TimelinePositionOption.POSITION_CENTER) {
                this.horizontalPosition = TimelinePositionOption.POSITION_CENTER_HORIZONTAL.INSTANCE;
            }
        } else if (property2 instanceof PointStyle) {
            Property<T> property3 = property;
            this.currentPainter = property3 instanceof PointStyle.SQUARE ? this.squarePainter : this.circlePainter;
        }
        this.circlePainter.updateProperty(property);
        this.squarePainter.updateProperty(property);
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        TimelinePositionOption timelinePositionOption = this.verticalPosition;
        Rect vRect = Intrinsics.areEqual((Object)timelinePositionOption, (Object)TimelinePositionOption.POSITION_TOP.INSTANCE) ? new Rect(rect.left, rect.top, rect.right, rect.top) : (Intrinsics.areEqual((Object)timelinePositionOption, (Object)TimelinePositionOption.POSITION_BOTTOM.INSTANCE) ? new Rect(rect.left, rect.bottom, rect.right, rect.bottom) : rect);
        TimelinePositionOption timelinePositionOption2 = this.horizontalPosition;
        Rect hRect = Intrinsics.areEqual((Object)timelinePositionOption2, (Object)TimelinePositionOption.POSITION_START.INSTANCE) ? new Rect(rect.left, vRect.top, rect.left, vRect.bottom) : (Intrinsics.areEqual((Object)timelinePositionOption2, (Object)TimelinePositionOption.POSITION_END.INSTANCE) ? new Rect(rect.right, vRect.top, rect.right, vRect.bottom) : rect);
        Rect useRect = new Rect(hRect.left, vRect.top, hRect.right, vRect.bottom);
        this.currentPainter.draw(canvas, useRect);
    }

    public PointPainter(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.circlePainter = new CirclePointStylePainter();
        this.currentPainter = this.squarePainter = (PointStylePainter)new SquarePointStylePainter();
        this.strokeColor = -1;
        this.fillColor = -7829368;
        this.fillSize = context.getResources().getDimension(R.dimen.default_pointFillSize);
        this.strokeSize = context.getResources().getDimension(R.dimen.default_pointStrokeSize);
        this.validVerticalPositions = CollectionsKt.listOf((Object[])new TimelinePositionOption[]{TimelinePositionOption.POSITION_TOP.INSTANCE, TimelinePositionOption.POSITION_CENTER.INSTANCE, TimelinePositionOption.POSITION_CENTER_VERTICAL.INSTANCE, TimelinePositionOption.POSITION_BOTTOM.INSTANCE});
        this.validHorizontalPositions = CollectionsKt.listOf((Object[])new TimelinePositionOption[]{TimelinePositionOption.POSITION_START.INSTANCE, TimelinePositionOption.POSITION_CENTER.INSTANCE, TimelinePositionOption.POSITION_CENTER_HORIZONTAL.INSTANCE, TimelinePositionOption.POSITION_END.INSTANCE});
        this.verticalPosition = TimelinePositionOption.POSITION_CENTER_VERTICAL.INSTANCE;
        this.horizontalPosition = TimelinePositionOption.POSITION_CENTER_HORIZONTAL.INSTANCE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/alorma/timeline/painter/point/PointPainter$Companion;", "", "()V", "CIRCLE", "", "SQUARE", "timeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

