/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.util.AttributeSet;
import com.alorma.timeline.TimelineView;

public class RoundTimelineView
extends TimelineView {
    public RoundTimelineView(Context context) {
        this(context, null);
    }

    public RoundTimelineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundTimelineView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @TargetApi(value=21)
    public RoundTimelineView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void drawIndicator(Canvas canvas, Paint paintStart, float centerX, float centerY, float size) {
        this.drawCircle(canvas, centerX, centerY, size, paintStart);
    }

    @Override
    protected void drawInternal(Canvas canvas, Paint paintInternal, float centerX, float centerY, float size) {
        this.drawCircle(canvas, centerX, centerY, size, paintInternal);
    }

    @Override
    protected void drawBitmap(Canvas canvas, float left, float top, int size) {
        if (this.internalBitmapCache == null) {
            this.internalBitmapCache = this.transform(this.internalBitmap, size);
        }
        canvas.drawBitmap(this.internalBitmapCache, left, top, null);
    }

    private void drawCircle(Canvas canvas, float centerX, float centerY, float radius, Paint paint) {
        if (canvas != null) {
            canvas.drawCircle(centerX, centerY, radius, paint);
        }
    }

    private Bitmap transform(Bitmap source, int size) {
        RoundedBitmapDrawable drawable = RoundedBitmapDrawableFactory.create((Resources)this.getResources(), (Bitmap)source);
        drawable.setCornerRadius(100.0f);
        Bitmap output = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)source.getConfig());
        Canvas canvas = new Canvas(output);
        drawable.setAntiAlias(true);
        drawable.setBounds(0, 0, size, size);
        drawable.draw(canvas);
        if (source != output) {
            source.recycle();
        }
        return output;
    }
}

