/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.alorma.timeline.TimelineView;

public class SquareTimelineView
extends TimelineView {
    private RectF rectF;

    public SquareTimelineView(Context context) {
        this(context, null);
    }

    public SquareTimelineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SquareTimelineView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.rectF = new RectF();
    }

    @TargetApi(value=21)
    public SquareTimelineView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    @Override
    public void drawIndicator(Canvas canvas, Paint paintStart, float centerX, float centerY, float size) {
        this.drawSquare(canvas, centerX, centerY, size, paintStart);
    }

    @Override
    protected void drawInternal(Canvas canvas, Paint paintInternal, float centerX, float centerY, float size) {
        this.drawSquare(canvas, centerX, centerY, size, paintInternal);
    }

    @Override
    protected void drawBitmap(Canvas canvas, float left, float top, int size) {
        if (this.internalBitmapCache == null) {
            this.internalBitmapCache = this.transform(this.internalBitmap, size);
        }
        canvas.drawBitmap(this.internalBitmapCache, left, top, null);
    }

    private void drawSquare(Canvas canvas, float centerX, float centerY, float size, Paint paint) {
        if (canvas != null) {
            this.rectF.left = centerX - size;
            this.rectF.top = centerY - size;
            this.rectF.right = centerX + size;
            this.rectF.bottom = centerY + size;
            canvas.drawRect(this.rectF.left, this.rectF.top, this.rectF.right, this.rectF.bottom, paint);
        }
    }

    private Bitmap transform(Bitmap source, int size) {
        Bitmap output = Bitmap.createScaledBitmap((Bitmap)source, (int)size, (int)size, (boolean)false);
        if (source != output) {
            source.recycle();
        }
        return output;
    }
}

