/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.services.AssetLoader;
import com.almasb.fxgl.audio.AudioKt;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.Sound;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/app/services/SoundAssetLoader;", "Lcom/almasb/fxgl/app/services/AssetLoader;", "Lcom/almasb/fxgl/audio/Sound;", "audioService", "Lcom/almasb/fxgl/audio/AudioPlayer;", "isMobile", "", "(Lcom/almasb/fxgl/audio/AudioPlayer;Z)V", "getAudioService", "()Lcom/almasb/fxgl/audio/AudioPlayer;", "()Z", "getDummy", "load", "url", "Ljava/net/URL;", "fxgl"})
final class SoundAssetLoader
extends AssetLoader<Sound> {
    @NotNull
    private final AudioPlayer audioService;
    private final boolean isMobile;

    public SoundAssetLoader(@NotNull AudioPlayer audioService, boolean isMobile) {
        Intrinsics.checkNotNullParameter((Object)audioService, (String)"audioService");
        super(Sound.class, "/assets/sounds/", null);
        this.audioService = audioService;
        this.isMobile = isMobile;
    }

    @NotNull
    public final AudioPlayer getAudioService() {
        return this.audioService;
    }

    public final boolean isMobile() {
        return this.isMobile;
    }

    @Override
    @NotNull
    protected Sound load(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new Sound(this.audioService.loadAudio(AudioType.SOUND, url, this.isMobile));
    }

    @Override
    @NotNull
    public Sound getDummy() {
        return new Sound(AudioKt.getDummyAudio());
    }
}

