/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.action;

import com.almasb.fxgl.entity.action.Action;
import com.almasb.fxgl.entity.action.CancelPolicy;
import com.almasb.fxgl.entity.action.IdleAction;
import com.almasb.fxgl.entity.component.Component;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class ActionComponent
extends Component {
    private final Action IDLE = new IdleAction();
    private CancelPolicy cancelPolicy = CancelPolicy.ONE;
    private ObservableList<Action> actions = FXCollections.observableArrayList();
    private Action currentAction = this.IDLE;

    @Override
    public void onUpdate(double tpf) {
        if (this.currentAction != this.IDLE && this.currentAction.isCancelled()) {
            switch (this.cancelPolicy) {
                case ONE: {
                    this.removeCurrentActionAndSetNext();
                    break;
                }
                case ALL: {
                    this.cancelActions();
                }
            }
        }
        if (this.currentAction.isComplete()) {
            this.currentAction.onCompleted();
            this.removeCurrentActionAndSetNext();
        }
        if (!this.currentAction.isCancelled()) {
            this.currentAction.onUpdate(tpf);
        }
    }

    @Override
    public void onRemoved() {
        this.cancelActions();
    }

    public CancelPolicy getCancelPolicy() {
        return this.cancelPolicy;
    }

    public void setCancelPolicy(CancelPolicy cancelPolicy) {
        this.cancelPolicy = cancelPolicy;
    }

    public ObservableList<Action> actionsProperty() {
        return FXCollections.unmodifiableObservableList(this.actions);
    }

    public Action getCurrentAction() {
        return this.currentAction;
    }

    public boolean isIdle() {
        return this.currentAction == this.IDLE;
    }

    public boolean hasNextActions() {
        return !this.actions.isEmpty();
    }

    public void cancelActions() {
        this.actions.forEach(Action::cancel);
        this.actions.clear();
        this.removeCurrentActionAndSetNext();
    }

    public void addAction(Action action) {
        action.setEntity(this.entity);
        this.actions.add((Object)action);
        action.onQueued();
    }

    public void removeAction(Action action) {
        action.cancel();
        this.actions.remove((Object)action);
    }

    private void removeCurrentActionAndSetNext() {
        if (!this.isIdle() && !this.actions.isEmpty()) {
            this.actions.remove(0);
        }
        this.currentAction = this.getNextAction();
        if (!this.currentAction.isCancelled()) {
            this.currentAction.onStarted();
        }
    }

    public Action getNextAction() {
        return this.hasNextActions() ? (Action)this.actions.get(0) : this.IDLE;
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

