/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.joints;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.SolverData;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointEdge;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

public abstract class Joint {
    public Joint m_prev = null;
    public Joint m_next = null;
    public final JointEdge m_edgeA = new JointEdge();
    public final JointEdge m_edgeB = new JointEdge();
    protected Body m_bodyA;
    protected Body m_bodyB;
    public boolean m_islandFlag = false;
    private final boolean m_collideConnected;
    private Object m_userData;
    protected final IWorldPool pool;

    public static <T extends Joint> T create(World world, JointDef<T> def) {
        return def.createJoint(world);
    }

    public static void destroy(Joint joint) {
        joint.destructor();
    }

    protected Joint(IWorldPool worldPool, JointDef def) {
        this.pool = worldPool;
        this.m_bodyA = def.getBodyA();
        this.m_bodyB = def.getBodyB();
        this.m_collideConnected = def.isBodyCollisionAllowed();
        this.m_userData = def.getUserData();
    }

    public final Body getBodyA() {
        return this.m_bodyA;
    }

    public final Body getBodyB() {
        return this.m_bodyB;
    }

    public abstract void getAnchorA(Vec2 var1);

    public abstract void getAnchorB(Vec2 var1);

    public abstract void getReactionForce(float var1, Vec2 var2);

    public abstract float getReactionTorque(float var1);

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object data) {
        this.m_userData = data;
    }

    public final boolean getCollideConnected() {
        return this.m_collideConnected;
    }

    public abstract void initVelocityConstraints(SolverData var1);

    public abstract void solveVelocityConstraints(SolverData var1);

    public abstract boolean solvePositionConstraints(SolverData var1);

    public void destructor() {
    }
}

