/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.core.util.LazyValue;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.pathfinding.CellMoveComponent;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import com.almasb.fxgl.pathfinding.astar.AStarGrid;
import com.almasb.fxgl.pathfinding.astar.AStarPathfinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.beans.value.ChangeListener;

@Required(value=CellMoveComponent.class)
public final class AStarMoveComponent
extends Component {
    private CellMoveComponent moveComponent;
    private LazyValue<AStarPathfinder> pathfinder;
    private List<AStarCell> path = new ArrayList<AStarCell>();
    private Runnable delayedPathCalc = EmptyRunnable.INSTANCE;
    private ChangeListener<Boolean> isAtDestinationListener = (o, old, isAtDestination) -> {
        if (isAtDestination.booleanValue()) {
            this.delayedPathCalc.run();
            this.delayedPathCalc = EmptyRunnable.INSTANCE;
        }
    };

    public AStarMoveComponent(AStarGrid grid) {
        this((LazyValue<AStarGrid>)new LazyValue(() -> grid));
    }

    public AStarMoveComponent(LazyValue<AStarGrid> grid) {
        this.pathfinder = new LazyValue(() -> new AStarPathfinder((AStarGrid)((Object)((Object)grid.get()))));
    }

    @Override
    public void onAdded() {
        this.moveComponent = this.entity.getComponent(CellMoveComponent.class);
        this.moveComponent.atDestinationProperty().addListener(this.isAtDestinationListener);
    }

    @Override
    public void onRemoved() {
        this.moveComponent.atDestinationProperty().removeListener(this.isAtDestinationListener);
    }

    public boolean isMoving() {
        return this.moveComponent.isMoving();
    }

    public boolean isPathEmpty() {
        return this.path.isEmpty();
    }

    public boolean isAtDestination() {
        return !this.isMoving() && this.isPathEmpty();
    }

    public AStarGrid getGrid() {
        return ((AStarPathfinder)this.pathfinder.get()).getGrid();
    }

    public Optional<AStarCell> getCurrentCell() {
        int cellX = this.moveComponent.getCellX();
        int cellY = this.moveComponent.getCellY();
        return this.getGrid().getOptional(cellX, cellY);
    }

    public void stopMovementAt(int cellX, int cellY) {
        this.path.clear();
        this.moveComponent.setPositionToCell(cellX, cellY);
    }

    public void stopMovement() {
        this.stopMovementAt(this.moveComponent.getCellX(), this.moveComponent.getCellY());
    }

    public void moveToRightCell() {
        this.getGrid().getRight(this.moveComponent.getCellX(), this.moveComponent.getCellY()).ifPresent(this::moveToCell);
    }

    public void moveToLeftCell() {
        this.getGrid().getLeft(this.moveComponent.getCellX(), this.moveComponent.getCellY()).ifPresent(this::moveToCell);
    }

    public void moveToUpCell() {
        this.getGrid().getUp(this.moveComponent.getCellX(), this.moveComponent.getCellY()).ifPresent(this::moveToCell);
    }

    public void moveToDownCell() {
        this.getGrid().getDown(this.moveComponent.getCellX(), this.moveComponent.getCellY()).ifPresent(this::moveToCell);
    }

    public void moveToRandomCell() {
        this.moveToRandomCell(FXGLMath.getRandom());
    }

    public void moveToRandomCell(Random random) {
        this.getGrid().getRandomCell(random, AStarCell::isWalkable).ifPresent(this::moveToCell);
    }

    public void moveToCell(AStarCell cell) {
        this.moveToCell(cell.getX(), cell.getY());
    }

    public void moveToCell(int x, int y) {
        int startX = this.moveComponent.getCellX();
        int startY = this.moveComponent.getCellY();
        this.moveToCell(startX, startY, x, y);
    }

    public void moveToCell(int startX, int startY, int targetX, int targetY) {
        if (this.moveComponent.isAtDestination()) {
            this.path = ((AStarPathfinder)this.pathfinder.get()).findPath(startX, startY, targetX, targetY);
        } else {
            this.delayedPathCalc = () -> {
                this.path = ((AStarPathfinder)this.pathfinder.get()).findPath(this.moveComponent.getCellX(), this.moveComponent.getCellY(), targetX, targetY);
            };
        }
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.path.isEmpty() || !this.moveComponent.isAtDestination()) {
            return;
        }
        AStarCell next = this.path.remove(0);
        this.moveComponent.moveToCell(next.getX(), next.getY());
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

