/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import org.mozilla.universalchardet.UnicodeBOMInputStream;
import org.mozilla.universalchardet.UniversalDetector;

public final class ReaderFactory {
    private ReaderFactory() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static Reader createReaderFromFile(File file, Charset defaultCharset) throws IOException {
        Charset cs = Objects.requireNonNull(defaultCharset, "defaultCharset must be not null");
        String detectedEncoding = UniversalDetector.detectCharset(file);
        if (detectedEncoding != null) {
            cs = Charset.forName(detectedEncoding);
        }
        if (!cs.toString().contains("UTF")) {
            return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), cs);
        }
        return new InputStreamReader((InputStream)new UnicodeBOMInputStream(new BufferedInputStream(new FileInputStream(file))), cs);
    }

    public static Reader createReaderFromFile(File file) throws IOException {
        return ReaderFactory.createReaderFromFile(file, Charset.defaultCharset());
    }
}

