/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import com.aefyr.pseudoapksigner.ManifestBuilder;
import com.aefyr.pseudoapksigner.SignatureFileGenerator;
import com.aefyr.pseudoapksigner.Utils;
import com.aefyr.pseudoapksigner.ZipAlignZipOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PseudoApkSigner {
    private static final String HASHING_ALGORITHM = "SHA1";
    private RSAPrivateKey mPrivateKey;
    private File mTemplateFile;
    private String mSignerName = "CERT";

    public PseudoApkSigner(File template, File privateKey) throws Exception {
        this.mTemplateFile = template;
        this.mPrivateKey = Utils.readPrivateKey(privateKey);
    }

    public void sign(File apkFile, File output) throws Exception {
        this.sign(new FileInputStream(apkFile), new FileOutputStream(output));
    }

    public void sign(InputStream apkInputStream, OutputStream output) throws Exception {
        ZipEntry zipEntry;
        ManifestBuilder manifest = new ManifestBuilder();
        SignatureFileGenerator signature = new SignatureFileGenerator(manifest, HASHING_ALGORITHM);
        ZipInputStream apkZipInputStream = new ZipInputStream(apkInputStream);
        ZipAlignZipOutputStream zipOutputStream = ZipAlignZipOutputStream.create(output, 4);
        MessageDigest messageDigest = MessageDigest.getInstance(HASHING_ALGORITHM);
        while ((zipEntry = apkZipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory() || zipEntry.getName().toLowerCase().startsWith("meta-inf")) continue;
            messageDigest.reset();
            DigestInputStream entryInputStream = new DigestInputStream(apkZipInputStream, messageDigest);
            ZipEntry newZipEntry = new ZipEntry(zipEntry.getName());
            newZipEntry.setMethod(zipEntry.getMethod());
            if (zipEntry.getMethod() == 0) {
                newZipEntry.setSize(zipEntry.getSize());
                newZipEntry.setCompressedSize(zipEntry.getSize());
                newZipEntry.setCrc(zipEntry.getCrc());
            }
            zipOutputStream.setAlignment(newZipEntry.getName().endsWith(".so") ? 4096 : 4);
            zipOutputStream.putNextEntry(newZipEntry);
            Utils.copyStream(entryInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
            apkZipInputStream.closeEntry();
            ManifestBuilder.ManifestEntry manifestEntry = new ManifestBuilder.ManifestEntry();
            manifestEntry.setAttribute("Name", zipEntry.getName());
            manifestEntry.setAttribute("SHA1-Digest", Utils.base64Encode(messageDigest.digest()));
            manifest.addEntry(manifestEntry);
        }
        zipOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        zipOutputStream.write(manifest.build().getBytes("UTF-8"));
        zipOutputStream.closeEntry();
        zipOutputStream.putNextEntry(new ZipEntry(String.format("META-INF/%s.SF", this.mSignerName)));
        zipOutputStream.write(signature.generate().getBytes("UTF-8"));
        zipOutputStream.closeEntry();
        zipOutputStream.putNextEntry(new ZipEntry(String.format("META-INF/%s.RSA", this.mSignerName)));
        zipOutputStream.write(Utils.readFile(this.mTemplateFile));
        zipOutputStream.write(Utils.sign(HASHING_ALGORITHM, this.mPrivateKey, signature.generate().getBytes("UTF-8")));
        zipOutputStream.closeEntry();
        apkZipInputStream.close();
        zipOutputStream.close();
    }

    public void setSignerName(String signerName) {
        this.mSignerName = signerName;
    }
}

