/*
 * Decompiled with CFR 0.152.
 */
package com.github.aakira.expandablelayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.github.aakira.expandablelayout.ExpandableLayout;
import com.github.aakira.expandablelayout.ExpandableLayoutListener;
import com.github.aakira.expandablelayout.ExpandableSavedState;
import com.github.aakira.expandablelayout.R;
import com.github.aakira.expandablelayout.Utils;

public class ExpandableWeightLayout
extends RelativeLayout
implements ExpandableLayout {
    private int duration;
    private boolean isExpanded;
    private TimeInterpolator interpolator = new LinearInterpolator();
    private ExpandableLayoutListener listener;
    private ExpandableSavedState savedState;
    private float layoutWeight = 0.0f;
    private boolean isArranged = false;
    private boolean isCalculatedSize = false;
    private boolean isAnimating = false;
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;

    public ExpandableWeightLayout(Context context) {
        this(context, null);
    }

    public ExpandableWeightLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandableWeightLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ExpandableWeightLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.expandableLayout, defStyleAttr, 0);
        this.duration = a.getInteger(R.styleable.expandableLayout_ael_duration, 300);
        this.isExpanded = a.getBoolean(R.styleable.expandableLayout_ael_expanded, false);
        int interpolatorType = a.getInteger(R.styleable.expandableLayout_ael_interpolator, 8);
        this.interpolator = Utils.createInterpolator(interpolatorType);
        a.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!(this.getLayoutParams() instanceof LinearLayout.LayoutParams)) {
            throw new AssertionError((Object)"You must arrange in LinearLayout.");
        }
        if (0.0f >= this.getCurrentWeight()) {
            throw new AssertionError((Object)"You must set a weight than 0.");
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isCalculatedSize) {
            this.layoutWeight = this.getCurrentWeight();
            this.isCalculatedSize = true;
        }
        if (this.isArranged) {
            return;
        }
        this.setWeight(this.isExpanded ? this.layoutWeight : 0.0f);
        this.isArranged = true;
        if (this.savedState == null) {
            return;
        }
        this.setWeight(this.savedState.getWeight());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        ExpandableSavedState ss = new ExpandableSavedState(parcelable);
        ss.setWeight(this.getCurrentWeight());
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ExpandableSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ExpandableSavedState ss = (ExpandableSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.savedState = ss;
    }

    @Override
    public void setListener(@NonNull ExpandableLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public void toggle() {
        this.toggle(this.duration, this.interpolator);
    }

    @Override
    public void toggle(long duration, @Nullable TimeInterpolator interpolator) {
        if (0.0f < this.getCurrentWeight()) {
            this.collapse(duration, interpolator);
        } else {
            this.expand(duration, interpolator);
        }
    }

    @Override
    public void expand() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(0.0f, this.layoutWeight, this.duration, this.interpolator).start();
    }

    @Override
    public void expand(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.isExpanded = true;
            this.setWeight(this.layoutWeight);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentWeight(), this.layoutWeight, duration, interpolator).start();
    }

    @Override
    public void collapse() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentWeight(), 0.0f, this.duration, this.interpolator).start();
    }

    @Override
    public void collapse(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.isExpanded = false;
            this.setWeight(0.0f);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentWeight(), 0.0f, duration, interpolator).start();
    }

    @Override
    public void initLayout(boolean isMaintain) {
        this.layoutWeight = 0.0f;
        this.isArranged = isMaintain;
        this.isCalculatedSize = false;
        this.savedState = null;
        super.requestLayout();
    }

    @Override
    public void setDuration(@NonNull int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.duration = duration;
    }

    @Override
    public void setExpanded(boolean expanded) {
        if (this.isExpanded == expanded) {
            return;
        }
        this.isExpanded = expanded;
        this.setWeight(expanded ? this.layoutWeight : 0.0f);
        this.requestLayout();
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setInterpolator(@NonNull TimeInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public float getCurrentWeight() {
        return ((LinearLayout.LayoutParams)this.getLayoutParams()).weight;
    }

    public void move(float weight) {
        this.move(weight, this.duration, this.interpolator);
    }

    public void move(float weight, long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.isExpanded = weight > 0.0f;
            this.setWeight(weight);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentWeight(), weight, duration, interpolator).start();
    }

    private ValueAnimator createExpandAnimator(float from, final float to, long duration, @Nullable TimeInterpolator interpolator) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        valueAnimator.setDuration(duration);
        valueAnimator.setInterpolator(interpolator == null ? this.interpolator : interpolator);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ExpandableWeightLayout.this.setWeight(((Float)animation.getAnimatedValue()).floatValue());
                ExpandableWeightLayout.this.requestLayout();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ExpandableWeightLayout.this.isAnimating = true;
                if (ExpandableWeightLayout.this.listener == null) {
                    return;
                }
                ExpandableWeightLayout.this.listener.onAnimationStart();
                if (ExpandableWeightLayout.this.layoutWeight == to) {
                    ExpandableWeightLayout.this.listener.onPreOpen();
                    return;
                }
                if (0.0f == to) {
                    ExpandableWeightLayout.this.listener.onPreClose();
                }
            }

            public void onAnimationEnd(Animator animation) {
                ExpandableWeightLayout.this.isAnimating = false;
                float currentWeight = ExpandableWeightLayout.this.getCurrentWeight();
                ExpandableWeightLayout.this.isExpanded = currentWeight > 0.0f;
                if (ExpandableWeightLayout.this.listener == null) {
                    return;
                }
                ExpandableWeightLayout.this.listener.onAnimationEnd();
                if (currentWeight == ExpandableWeightLayout.this.layoutWeight) {
                    ExpandableWeightLayout.this.listener.onOpened();
                    return;
                }
                if (currentWeight == 0.0f) {
                    ExpandableWeightLayout.this.listener.onClosed();
                }
            }
        });
        return valueAnimator;
    }

    private void setWeight(float weight) {
        ((LinearLayout.LayoutParams)this.getLayoutParams()).weight = weight;
    }

    private void notifyListeners() {
        if (this.listener == null) {
            return;
        }
        this.listener.onAnimationStart();
        if (this.isExpanded) {
            this.listener.onPreOpen();
        } else {
            this.listener.onPreClose();
        }
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    ExpandableWeightLayout.this.getViewTreeObserver().removeGlobalOnLayoutListener(ExpandableWeightLayout.this.mGlobalLayoutListener);
                } else {
                    ExpandableWeightLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener(ExpandableWeightLayout.this.mGlobalLayoutListener);
                }
                ExpandableWeightLayout.this.listener.onAnimationEnd();
                if (ExpandableWeightLayout.this.isExpanded) {
                    ExpandableWeightLayout.this.listener.onOpened();
                } else {
                    ExpandableWeightLayout.this.listener.onClosed();
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalLayoutListener);
    }
}

