/*
 * Decompiled with CFR 0.152.
 */
package com.github.aakira.expandablelayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.github.aakira.expandablelayout.ExpandableLayout;
import com.github.aakira.expandablelayout.ExpandableLayoutListener;
import com.github.aakira.expandablelayout.ExpandableSavedState;
import com.github.aakira.expandablelayout.R;
import com.github.aakira.expandablelayout.Utils;

public class ExpandableWeightLayout
extends RelativeLayout
implements ExpandableLayout {
    private int duration;
    private boolean isExpanded;
    private TimeInterpolator interpolator = new LinearInterpolator();
    private ExpandableLayoutListener listener;
    private ExpandableSavedState savedState;
    private float layoutWeight = 0.0f;
    private boolean isArranged = false;
    private boolean isCalculatedSize = false;
    private boolean isAnimating = false;
    private boolean isWeightLayout = false;

    public ExpandableWeightLayout(Context context) {
        this(context, null);
    }

    public ExpandableWeightLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandableWeightLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ExpandableWeightLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.expandableLayout, defStyleAttr, 0);
        this.duration = a.getInteger(R.styleable.expandableLayout_ael_duration, 300);
        this.isExpanded = a.getBoolean(R.styleable.expandableLayout_ael_expanded, false);
        int interpolatorType = a.getInteger(R.styleable.expandableLayout_ael_interpolator, 8);
        this.interpolator = Utils.createInterpolator(interpolatorType);
        a.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!(this.getLayoutParams() instanceof LinearLayout.LayoutParams)) {
            return;
        }
        if (0.0f < ((LinearLayout.LayoutParams)this.getLayoutParams()).weight) {
            this.isWeightLayout = 0.0f < ((LinearLayout.LayoutParams)this.getLayoutParams()).weight;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isWeightLayout) {
            return;
        }
        if (!this.isCalculatedSize) {
            this.layoutWeight = ((LinearLayout.LayoutParams)this.getLayoutParams()).weight;
            if (0.0f < this.layoutWeight) {
                this.isCalculatedSize = true;
            }
        }
        if (this.isArranged) {
            return;
        }
        ((LinearLayout.LayoutParams)this.getLayoutParams()).weight = this.isExpanded ? this.layoutWeight : 0.0f;
        this.isArranged = true;
        if (this.savedState == null) {
            return;
        }
        ((LinearLayout.LayoutParams)this.getLayoutParams()).weight = this.savedState.getWeight();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (!this.isWeightLayout) {
            return parcelable;
        }
        ExpandableSavedState ss = new ExpandableSavedState(parcelable);
        ss.setWeight(((LinearLayout.LayoutParams)this.getLayoutParams()).weight);
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ExpandableSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ExpandableSavedState ss = (ExpandableSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.savedState = ss;
    }

    @Override
    public void setListener(@NonNull ExpandableLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public void toggle() {
        if (!this.isWeightLayout) {
            return;
        }
        if (0.0f < ((LinearLayout.LayoutParams)this.getLayoutParams()).weight) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    @Override
    public void expand() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(0.0f, this.layoutWeight).start();
    }

    @Override
    public void collapse() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.layoutWeight, 0.0f).start();
    }

    @Override
    public void initLayout() {
        this.layoutWeight = 0.0f;
        this.isArranged = false;
        this.isCalculatedSize = false;
        this.savedState = null;
        super.requestLayout();
    }

    @Override
    public void setDuration(@NonNull int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.duration = duration;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        this.requestLayout();
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setInterpolator(@NonNull TimeInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    private void updateLayout() {
        super.requestLayout();
    }

    public ValueAnimator createExpandAnimator(float from, final float to) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        valueAnimator.setDuration((long)this.duration);
        valueAnimator.setInterpolator(this.interpolator);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (!ExpandableWeightLayout.this.isWeightLayout) {
                    return;
                }
                ((LinearLayout.LayoutParams)ExpandableWeightLayout.this.getLayoutParams()).weight = ((Float)animation.getAnimatedValue()).floatValue();
                ExpandableWeightLayout.this.updateLayout();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ExpandableWeightLayout.this.isAnimating = true;
                if (ExpandableWeightLayout.this.listener == null) {
                    return;
                }
                ExpandableWeightLayout.this.listener.onAnimationStart();
                if (ExpandableWeightLayout.this.layoutWeight == to) {
                    ExpandableWeightLayout.this.listener.onPreOpen();
                    return;
                }
                if (0.0f == to) {
                    ExpandableWeightLayout.this.listener.onPreClose();
                }
            }

            public void onAnimationEnd(Animator animation) {
                ExpandableWeightLayout.this.isAnimating = false;
                if (ExpandableWeightLayout.this.listener == null) {
                    return;
                }
                ExpandableWeightLayout.this.listener.onAnimationEnd();
                if (!ExpandableWeightLayout.this.isWeightLayout) {
                    return;
                }
                float currentWeight = ((LinearLayout.LayoutParams)ExpandableWeightLayout.this.getLayoutParams()).weight;
                if (currentWeight == ExpandableWeightLayout.this.layoutWeight) {
                    ExpandableWeightLayout.this.listener.onOpened();
                    ExpandableWeightLayout.this.isExpanded = true;
                    return;
                }
                if (currentWeight == 0.0f) {
                    ExpandableWeightLayout.this.listener.onClosed();
                    ExpandableWeightLayout.this.isExpanded = false;
                }
            }
        });
        return valueAnimator;
    }
}

